/*
**	creates an empty passwd file
*/

#include	<local-system>
#include	<passwd.h>
#include	<sys/stat.h>

#define	BINUID	2
#define	BINGID	2

main(argc,argv)
	register char	*argv[];
{
	register	fd, i;
	register char	*fn;
	pwaddr_t	buf[PWTABSIZE+PWHASHSIZE];

	if(argc > 1)
		/* alternate passwd file */

		fn = *(++argv);
	else
		/* normal passwd file */

		fn = ETCPASSWD;

	if ( access(fn, 0) == 0 )
		unlink(fn);

	if (mknod(fn, S_IFLOK+0644, 0) == SYSERROR)
	{
		perror(fn);
		return 1;
	}

	chown(fn, BINUID, BINGID);
	chmod(fn, 0644);
	if((fd = open(fn, 1)) == SYSERROR)
	{
		perror(fn);
		return 1;
	}

	writelock(fd);

	for(i=0; i< (PWTABSIZE+PWHASHSIZE); i++) buf[i]=PWENTNULL;

	if(write(fd,buf,PWTABLEN) != PWTABLEN)
	{
		perror( fn );
		return 1;
	}

	unlock();
}
