h43301
s 00016/00006/00301
d D 1.5 81/05/18 19:27:03 root 5 4
c correct previous fix
e
s 00008/00010/00299
d D 1.4 81/05/17 17:49:28 root 4 3
c allow unpacking of file.z.z.z etc. (obscure code fixed)
e
s 00008/00009/00301
d D 1.3 81/03/20 12:40:18 root 3 2
c minor corrections (Ian Grigg)
e
s 00003/00005/00307
d D 1.2 81/01/09 14:21:07 root 2 1
c original from elecvax 9/1/80, modified system call return tests
c and stat mode test values.
e
s 00312/00000/00000
d D 1.1 81/01/09 14:16:49 root 1 0
e
u
U
t
T
I 1
/*
 *	Huffman decompressor (new files replace old)
 *	Adapted April 1979, from a program by T.G. Szymanski, March 1978.
 *	Usage:	unpack filename...
 */

#include <stdio.h>
#include <setjmp.h>
D 4
#include <sys/types.h>
#include <sys/stat.h>
E 4
I 4
#include <types.h>
#include <stat.h>
E 4

jmp_buf env;
struct	stat status;

#define	BLKSIZE	512
#define NAMELEN 80
#define	SUF0	'.'
#define	SUF1	'z'
D 2
#define US 037
#define RS 036
E 2
I 2
#define US 037	/* signifies the old style packing */
#define RS 036	/* and this is the new style */
E 2
#ifdef pdp11
#define COMPATABILITY
#endif

/* variables associated with i/o */
char	filename [NAMELEN+2];
char *	currentf;	/* file to be unpacked */
D 3
char *	pgmname;	/* program name ie "unpack" */
E 3
int	infile;
int	outfile;
int	inleft;
char	*inp;
char	*outp;
char	inbuff [BLKSIZE];
char	outbuff [BLKSIZE];

/* the dictionary */
long	origsize;
int	maxlev;
int	intnodes [25];
char	*tree [25];
char	characters [256];
char	*eof;

/* read in the dictionary portion and build decoding structures */
/* return 1 if successful, 0 otherwise */
getdict ()
{
	register int c, i, nchildren;
	/*
	 * check two-byte header
	 * get size of original file,
	 * get number of levels in maxlev,
	 * get number of leaves on level i in intnodes[i],
	 * set tree[i] to point to leaves for level i
	 */
	eof = &characters[0];
	inbuff[6] = 25;
	inleft = read(infile, &inbuff[0], BLKSIZE);
	if (inleft < 0) {
		packerror (".z: read error\n");
		return (0);
	}
	if (inbuff[0] != US) goto goof;
#ifdef COMPATABILITY
	if (inbuff[1] == US) { /* oldstyle packing */
D 2
		packerror (": old-style\n");
E 2
		if (setjmp(env)) return (0);
		expand();
		return (1);
	}
#endif
	if (inbuff[1] != RS) goto goof;

	inp = &inbuff[2];
	origsize = 0;
	for (i=0; i<4; i++) {
		origsize = origsize*256 + ((*inp++) & 0377);
	}
	maxlev = *inp++ & 0377;
	if (maxlev > 24) {
goof:		packerror (".z: not in packed format\n");
		return (0);
	}
	for (i=1; i<=maxlev; i++)
		intnodes[i] = *inp++ & 0377;
	for (i=1; i<=maxlev; i++) {
		tree[i] = eof;
		for (c=intnodes[i]; c>0; c--) {
			if (eof >= &characters[255])
				goto goof;
			*eof++ = *inp++;
		}
	}
	*eof++ = *inp++;
	intnodes[maxlev] += 2;
	inleft -= inp-&inbuff[0];
	if (inleft < 0)
		goto goof;

	/*
	 * convert intnodes[i] to be number of
	 * internal nodes possessed by level i
	 */
	nchildren = 0;
	for (i=maxlev; i>=1; i--) {
		c = intnodes[i];
		intnodes[i] = nchildren /= 2;
		nchildren += c;
	}
	return (decode());
}

/* unpack the file */
/* return 1 if successful, 0 otherwise */
int decode ()
{
	register int bitsleft, c, i;
	int j, lev;
	char *p;
	outp = &outbuff[0];
	lev = 1;
	i = 0;
	while (1) {
		if (inleft <= 0) {
			inleft = read(infile, inp = &inbuff[0], BLKSIZE);
			if (inleft < 0) {
				packerror (".z: read error\n");
				return (0);
			}
		}
		if (--inleft < 0) {
uggh:			packerror (".z: unpacking error\n");
			return (0);
		}
		c = *inp++;
		bitsleft = 8;
		while (--bitsleft >= 0) {
			i *= 2;
			if (c & 0200)
				i++;
			c <<= 1;
			if ((j = i-intnodes[lev]) >= 0) {
				p = &tree[lev][j];
				if (p == eof) {
					c = outp-&outbuff[0];
					if (write(outfile, outbuff, c) != c) {
wrerr:						packerror (": write error\n");
						return (0);
					}
					origsize -= c;
					if (origsize != 0) goto uggh;
					return(1);
				}
				*outp++ = *p;
				if (outp == &outbuff[BLKSIZE]) {
					if (write(outfile, outp = &outbuff[0], BLKSIZE) != BLKSIZE)
						goto wrerr;
					origsize -= BLKSIZE;
				}
				lev = 1;
				i = 0;
			} else
				lev++;
		}
	}
}


main(argc, argv)
int argc; char *argv[];
{       register int i, k;
	int sep;
	register char *cp;
	int fcount = 0; /* failure count */

	umask(0);
D 3
	pgmname = argv[0];	/* so packerror knows who it is */
E 3

	for (k = 1; k<argc; k++)
	{
		currentf = argv[k];	/* for packerror */
		sep = -1;  cp = filename;
		for (i=0; i < (NAMELEN-3) && (*cp = argv[k][i]); i++)
			if (*cp++ == '/') sep = i;
D 4
		if (cp[-1]==SUF1 && cp[-2]==SUF0)
		{       argv[k][i-2] = '\0'; /* Remove suffix and try again */
			k--;
			continue;
		}
E 4

D 2
/*		printf ("%s: %s", argv[0], argv[k]);*/
E 2
		fcount++;  /* expect the worst */
D 5
		if (i >= (NAMELEN-3) || (i-sep) > 13)
		{       packerror (": file name too long\n");
E 5
I 5
		sep = i - sep - 1;	/* nr of chars in name */
		if (i >= (NAMELEN-3) || sep > 14)
		{
namerr:
			packerror (": file name too long\n");
E 5
D 3
			goto done;
E 3
I 3
			continue;
E 3
		}
D 4
		*cp++ = SUF0;  *cp++ = SUF1;  *cp = '\0';
E 4
D 5
		if ((infile = open(filename, 0)) == -1)
D 4
		{       packerror (".z: cannot open\n");
D 3
			goto done;
E 3
I 3
			continue;
E 4
I 4
		{	*cp++ = SUF0;  *cp++ = SUF1;  *cp = '\0';
			/* if failure add suffix and try again */
E 5
I 5
		if (cp[-1] == SUF1 && cp[-2] == SUF0 && (infile = open(filename, 0)) >= 0)
			argv[k][i - 2] = 0;
		else
		{
			if (sep > 12)
				goto namerr;
			*cp++ = SUF0;
			*cp++ = SUF1;
			*cp = 0;
E 5
			if ((infile = open(filename, 0)) == -1)
D 5
			{       packerror (": cannot open\n");
E 5
I 5
			{
				packerror(": cannot open\n");
E 5
				continue;
			}
E 4
E 3
		}

		if( stat(argv[k], &status) != -1 )
		{
			packerror (": already exists\n");
D 3
			goto closein;
E 3
I 3
			close(infile);
			continue;
E 3
		}
		fstat (infile, &status);
		if ( status.st_nlink != 1)
			packerror (".z: Warning: file has links\n");
D 2
		if ((outfile = creat (argv[k], status.st_mode&07777)) == -1)
E 2
I 2
		if ((outfile = creat (argv[k], status.st_mode & ~S_IFMT)) == -1)
E 2
		{       packerror (": cannot create\n");
D 3
			goto closein;
E 3
I 3
			close(infile);
			continue;
E 3
		}

		chown (argv[k], status.st_uid, status.st_gid);

		if (getdict()) {		/* unpack */
			fcount--; 	/* success after all */
			unlink(filename);
			utime(argv[k], &status.st_atime);/* preserve acc & mod dates */
		}
		else {
			unlink(argv[k]);
		}
		close(outfile);
D 3
closein:	close(infile);
done:	;
E 3
I 3
		close(infile);
E 3
	}
	return (fcount);
}

#ifdef COMPATABILITY
/* this code is for unpacking files, which were packed using the previous algorithm */
int Tree [1024];
expand()
{       register int tp, bit, word;
	int keysize, i, *t;

	outp = outbuff;
	inp = &inbuff[2];
	inleft -= 2;
	t = Tree;
	origsize = ((long int ) (unsigned) getwd())*256*256;
	origsize += (unsigned) getwd();
	for ( keysize=getwd(); keysize--; )
	{       if ((i = (unsigned) getch()) == 0377)
			*t++ = getwd();
		else
			*t++ = i & 0377;
	}

	bit = tp = 0;
	for (;;)
	{       if (bit <= 0)
		{       word = getwd();
			bit = 16;
		}
		tp += Tree[tp + (word<0)];
		word <<= 1;  bit--;
		if (Tree[tp] == 0)
		{       putch(Tree[tp+1]);
			tp = 0;
			if ((origsize -= 1) == 0) {
				write (outfile, outbuff, outp-&outbuff[0]);
				return;
			}
		}
	}
}

getch() {
	if (inleft <= 0) {
		inleft = read (infile, inp=inbuff, BLKSIZE);
		if (inleft < 0) {
			packerror (".z: read error\n");
			longjmp (env, 1);
		}
	}
	inleft--;
	return (*inp++ & 0377);
}

getwd() {
	register char c;
	register d;
	c = getch();
	d = getch();
	d <<= 8;
	d |= (c & 0377);
	return (d);
}

putch(c) char c; {
	register int n;
	*outp++ = c;
	if (outp == &outbuff[BLKSIZE]) {
		n = write (outfile, outp=outbuff, BLKSIZE);
		if (n < BLKSIZE) {
			packerror (": write error\n");
			longjmp (env, 2);
		}
	}
}
#endif

packerror(s)
register char * s;
{
D 3
	printf ( "%s: %s%s", pgmname, currentf, s );
E 3
I 3
	printf ( "%s%s", currentf, s );
E 3
}
E 1
