#include <param.h>
#include <systm.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <filsys.h>
#include <mount.h>
#include <proc.h>
#include <inode.h>
#include <seg.h>
#include <conf.h>
#include <buf.h>
#include <lnode.h>
#include <file.h>

extern struct proc proc[];
extern struct buf buf[];
extern struct lnode lnode[];
extern struct user u;
extern char b[];
extern struct mount mount[];

/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 */
main()
{

	startup();
	/*
	 * set up system process
	 */

	proc[0].p_addr = ka6->r[0];
	proc[0].p_size = USIZE;
	proc[0].p_stat = SRUN;
	proc[0].p_flag |= SLOAD|SSYS;
	proc[0].p_nice = NZERO;
	proc[0].p_lnode = &lnode[0];
	u.u_procp = &proc[0];
	u.u_cmask = CMASK;
	lnode[0].l_refcount = 1;
	lnode[0].l_muse = USIZE;

	/*
	 * Initialize devices and
	 * set up 'known' i-nodes
	 */

	clkstart();
	cinit();
	binit();
	iinit();
	rootdir = iget(rootdev, (ino_t)ROOTINO);
	rootdir->i_flag &= ~ILOCK;
	u.u_cdir = iget(rootdev, (ino_t)ROOTINO);
	u.u_cdir->i_flag &= ~ILOCK;
	u.u_rdir = NULL;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if(newproc())
	{
		expand(USIZE + (int)btoc(szicode));
		estabur((unsigned)0, btoc(szicode), (unsigned)0, 0, RO);
		copyout((caddr_t)icode, (caddr_t)0, szicode);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return;
	}
	sched();
}

/*
 * iinit is called once (from main)
 * very early in initialization.
 * It "mounts" the root and swap devices
 * for reading and writing,
 * reads the root's super block
 * and initializes the current date
 * from the last modified date.
 *
 * panic: iinit -- cannot read the super
 * block. Usually because of an IO error.
 */
iinit()
{
	register struct buf *bp;
	register struct filsys *fp;

	(*bdevsw[major(rootdev)].d_open)(rootdev, FREAD|FWRITE);
	(*bdevsw[major(swapdev)].d_open)(swapdev, FREAD|FWRITE);
	bp = bread(rootdev, SUPERB);
	if(u.u_error)
		panic("iinit");
	bp->b_flags |= B_SUPER;
	brelse(bp);
	mount[0].m_bufp = bp;
	mount[0].m_dev = rootdev;
	ka5->r[0] = baddr(bp);
	fp = (struct filesys *)&b;
	fp->s_flock = 0;
	fp->s_ilock = 0;
	fp->s_ronly = 0;
	time = fp->s_time;
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all buffer hash lists to empty.
 */
binit()
{
	register unsigned ba;
	register i;
	extern struct buf bfreelist;

	ba = bufarea;
	bfreelist.b_forw = bfreelist.b_back =
	    bfreelist.av_forw = bfreelist.av_back = &bfreelist;
	for (i = 0; i < NBUF; i++)
	{
		register struct buf *bp;

		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_addr = ba << 6;
		bp->b_xmem = (ba >> 10) & 077;
		ba += btoc(BSIZE);
		bp->b_back = &bfreelist;
		bp->b_forw = bfreelist.b_forw;
		bfreelist.b_forw->b_back = bp;
		bfreelist.b_forw = bp;
		bp->b_flags = B_BUSY;
		brelse(bp);
	}
	{
		register struct bdevsw *bdp;

		for (bdp = bdevsw; bdp->d_open; bdp++)
			nblkdev++;
	}
	{
		register struct bhash *bhp;
		extern struct bhash bhash[];

		for (bhp = bhash; bhp < &bhash[NBHASH]; bhp++)
			bhp->b_forw = bhp->b_back = bhp;
	}
}
