/*
 * Flag values accessible to open(2) and fcntl(2)
 *  (The first three can only be set by open)
 */
#define	O_READ	0
#define	O_WRITE	1
#define	O_RDWR	2

#define	O_NDELAY	0004	/* Non-blocking I/O */
#define	O_APPEND	0010	/* append (writes guaranteed at the end) */
#define	O_FREE		0020	/* turn off disk usage charges */
#define	O_EXCL		0040	/* exclusive open */
/*
 * Flag values accessible only to open(2)
 * Note that O_CREAT does not imply O_TRUNC
 */
#define	O_CREAT		00400	/* open with file create (uses third arg) */
#define	O_TRUNC		01000	/* open with truncation */

/*
 * fcntl(2) requests
 */
#define	F_DUPFD		0	/* Duplicate fildes */
#define	F_GETFD		1	/* Get fildes flag */
#define	F_SETFD		2	/* Set fildes flag */
#define	F_GETFL		3	/* Get file flags */
#define	F_SETFL		4	/* Set file flags */
#define	F_RLOCK		5	/* Lock file against writing */
#define	F_WLOCK		6	/* Lock file for exclusive use */
#define	F_UNLOCK	7	/* Unlock a locked file */
