nes */
# define DOWN 012
# define UP 013
# define LEFT 010
# define RIGHT 040
# define BEL 007
# define ACK 006
#define PLOTIN 063
#define PLOTOUT 064
# define CR 015
# define FF 014
# define VERTRESP 48
# define HORZRESP 60.
# define HORZRES 6.
# define VERTRES 8.
/* down is line feed, up is reverse oyne feed,
   left is bwckspace, right is space.  48 points per inch
   vertically, 60 horizontally */

int xnow, ynow;
int ITTY[3], PTTY[3], OUTF;
float HEIGHT 6.0, WIDTH 6.0, OFFSET 0.0;
int xscale, xoffset, yscale;
float botx 0., boty 0., obotx 0., oboty 0.;
float scalex 1., scaley 1.;

openpl ()
{
	extern fout;
	int reset();
		xnow = ynow = 0;
		OUTF = 1;
		printf("\r");
		gtty(OUTF, ITTY);
		signal (2, &reset);
		PTTY[0] = ITTY[0];
		PTTY[1] = ITTY[1];
		PTTY[2] = ITTY[2] & (~ 020);  /* don't map lf */
		PTTY[2] =| 001; /* no delays */
		/* initialize constants */
		fout = 1;
		xscale  = 4096./(HORZRESP * WIDTH);
		yscale = 4096 /(VERTRESP * HEIGHT);
		xoffset = OFFSET * HORZRESP;
		return;
}

openvt(){
openpl();
}
point.c       N
T)  7 point(xi,yi){
		move(xi,yi);
		label(".");
		return;
}
tspace.c       N
U)   # include "con.h"
space(x0,y0,x1,y1){
	botx = -2047.;
	boty = -2047.;
	obotx = x0;
	oboty = y0;
	scalex = 4096./(x1-x0);
	scaley = 4096./(y1-y0);
}
subr.c        W
|)  o#include "con.h"
abval(q)
{
	return (q>=0 ? q : -q);
}

xconv (xp)
{
	/* x position input is -2047 to +2047, output must be 0 to PAGSIZ*HORZRES */
	xp =+ 2048;
	/* the computation is newx = xp*(PAGSIZ*HORZRES)/4096 */
	return (xoffset + xp /xscale);
}

yconv (yp)
{
	/* see description of xconv */
	yp =+ 2048;
	return (yp / yscale);
}

inplot()
{
	stty(OUTF, PTTY);
	spew (ESC);
	spew(PLOTIN);
}

outplot()
{
	extern struct {
		int fildes, nunused; 
		char *nxtfree, buff[512];
	} 
	fout;
	spew(ESC);
	spew(PLOTOUT);
	fflush(&fout);
	stty (OUTF, ITTY);
}

spew(ch)
{
	extern struct {
		int fildes, nunused; 
		char *nxtfree, buff[512];
	} 
	fout;
	if(ch == UP){
		putc(ESC,&fout);
		ch = DOWN;
	}
	putc(ch, &fout);
}

tobotleft ()
{
	move(-2048,-2048);
}
reset()
{
	outplot();
	exit();
}

float
dist2 (x1, y1, x2, y2)
{
	float t,v;
	t