/* ea.c - Calculate, load, and store using the proper effective address as
 * specified by the current instruction.  Also push and pop stack operations. */


#include "defines.h"
extern uint16_t dwrite_base;

/* load_ea() */

void 
load_ea(addr)
    uint16_t *addr;
{
    uint16_t indirect;

    switch (DST_MODE) {
    case 0:
	illegal();
    case 1:
	*addr = regs[DST_REG];
	return;
    case 2:
	*addr = regs[DST_REG];	/* this is wrong for 11/34 */
	regs[DST_REG] += 2;
	return;
    case 3:
	indirect = regs[DST_REG];	/* this is wrong for 11/34 */
	regs[DST_REG] += 2;
	lli_word(indirect, *addr);
	return;
    case 4:
	regs[DST_REG] -= 2;
	*addr = regs[DST_REG];
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	lli_word(indirect, *addr);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	*addr = regs[DST_REG] + indirect;
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[DST_REG] + indirect;
	    ll_word(indirect, *addr);
	return;
    }
    illegal();
}


/* pop() */

void 
pop(data)
    uint16_t *data;
{

    ll_word(regs[SP], *data);
    regs[SP] += 2;
}


/* push() */

void 
push(data)
    uint16_t data;
{
    regs[SP] -= 2;
    sl_word(regs[SP], data);
}


/* loadb_dst() */

void 
loadb_dst(data)
    uint8_t *data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	*data = regs[DST_REG] & 0377;
	return;
    case 1:
	addr = regs[DST_REG];
	ea_addr = addr;
	if (DST_REG == PC) {
	    lli_byte(addr, *data)
	} else {
	    ll_byte(addr, *data);
	}
	return;
    case 2:
	addr = regs[DST_REG];
	ea_addr = addr;
	if (DST_REG == PC) {
	    lli_byte(addr, *data)
	} else {
	    ll_byte(addr, *data);
	}
	if (DST_REG >= 6)
	    regs[DST_REG] += 2;
	else
	    regs[DST_REG] += 1;
	return;
    case 3:
	indirect = regs[DST_REG];
	if (DST_REG == PC) {
	    lli_word(indirect, addr)
	} else {
	    ll_word(indirect, addr);
	}
	ea_addr = addr;
	ll_byte(addr, *data);
	regs[DST_REG] += 2;
	return;
    case 4:
	if (DST_REG >= 6)
	    regs[DST_REG] -= 2;
	else
	    regs[DST_REG] -= 1;
	addr = regs[DST_REG];
	ea_addr = addr;
	ll_byte(addr, *data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	ea_addr = addr;
	ll_byte(addr, *data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	ea_addr = addr;
	ll_byte(addr, *data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[DST_REG] + indirect;
            ll_word(indirect, addr);
	ea_addr = addr;
	ll_byte(addr, *data);
	return;
    }
    illegal();
}


/* loadb_src() */

void 
loadb_src(data)
    uint8_t *data;
{
    uint16_t addr, indirect;

    switch (SRC_MODE) {
    case 0:
	*data = regs[SRC_REG] & 0377;
	return;
    case 1:
	addr = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_byte(addr, *data);
	} else {
	    ll_byte(addr, *data);
	}
	return;
    case 2:
	addr = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_byte(addr, *data);
	} else {
	    ll_byte(addr, *data);
	}
	if (SRC_REG >= 6)
	    regs[SRC_REG] += 2;
	else
	    regs[SRC_REG] += 1;
	return;
    case 3:
	indirect = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_word(indirect, addr)
	} else {
	    ll_word(indirect, addr);
	}
	ll_byte(addr, *data);
	regs[SRC_REG] += 2;
	return;
    case 4:
	if (SRC_REG >= 6)
	    regs[SRC_REG] -= 2;
	else
	    regs[SRC_REG] -= 1;
	addr = regs[SRC_REG];
	ll_byte(addr, *data);
	return;
    case 5:
	regs[SRC_REG] -= 2;
	indirect = regs[SRC_REG];
	ll_word(indirect, addr);
	ll_byte(addr, *data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[SRC_REG] + indirect;
	ll_byte(addr, *data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[SRC_REG] + indirect;
            ll_word(indirect, addr);
	ll_byte(addr, *data);
	return;
    }
    illegal();
}


/* storeb_dst() - */

void 
storeb_dst(data)
    uint8_t data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	regs[DST_REG] += data;
	return;
    case 1:
	addr = regs[DST_REG];
	sl_byte(addr, data);
	return;
    case 2:
	addr = regs[DST_REG];
	sl_byte(addr, data);
	if (DST_REG >= 6)
	    regs[DST_REG] += 2;
	else
	    regs[DST_REG] += 1;
	return;
    case 3:
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	sl_byte(addr, data);
	regs[DST_REG] += 2;
	return;
    case 4:
	if (DST_REG >= 6)		/* xyz */
	    regs[DST_REG] -= 2;
	else
	    regs[DST_REG] -= 1;
	addr = regs[DST_REG];
	sl_byte(addr, data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	sl_byte(addr, data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	sl_byte(addr, data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[DST_REG] + indirect;
            ll_word(indirect, addr);
	sl_byte(addr, data);
	return;
    }
    illegal();
}


/* storeb_dst_2() - */

void 
storeb_dst_2(data)
    uint8_t data;
{
    if (DST_MODE == 0) {
	regs[DST_REG] += data;
	return;
    }
    sl_byte(ea_addr, data);
}


/* loadp_dst() */

void 
loadp_dst(data)
    uint16_t *data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	*data = regs[DST_REG];
	return;
    case 1:
	addr = regs[DST_REG];
	ll_word(addr, *data);
	return;
    case 2:
	addr = regs[DST_REG];
	ll_word(addr, *data);
	regs[DST_REG] += 2;
	return;
    case 3:
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	ll_word(addr, *data);
	regs[DST_REG] += 2;
	return;
    case 4:
	regs[DST_REG] -= 2;
	addr = regs[DST_REG];
	ll_word(addr, *data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	ll_word(addr, *data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	if (DST_REG == PC)
            lli_word(addr, *data)
        else
            ll_word(addr, *data);
	return;
    case 7:
	not_impl();
    }
    illegal();
}


/* storep_dst() - */

void 
storep_dst(data)
    uint16_t data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	regs[DST_REG] = data;
	return;
    case 1:
	addr = regs[DST_REG];
	sl_word(addr, data);
	return;
    case 2:
	addr = regs[DST_REG];
	sl_word(addr, data);
	regs[DST_REG] += 2;
	return;
    case 3:
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	sl_word(addr, data);
	regs[DST_REG] += 2;
	return;
    case 4:
	regs[DST_REG] -= 2;
	addr = regs[DST_REG];
	sl_word(addr, data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	sl_word(addr, data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	sl_word(addr, data);
	return;
    case 7:
	not_impl();
    }
    illegal();
}


/* load_src() */

void 
load_src(data)
    uint16_t *data;
{
    uint16_t addr, indirect;

    switch (SRC_MODE) {
    case 0:
	*data = regs[SRC_REG];
	return;
    case 1:
	addr = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_word(addr, *data)
	} else {
	    ll_word(addr, *data);
	}
	return;
    case 2:
	addr = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_word(addr, *data)
	} else {
	    ll_word(addr, *data);
	}
	regs[SRC_REG] += 2;
	return;
    case 3:
	indirect = regs[SRC_REG];
	if (SRC_REG == PC) {
	    lli_word(indirect, addr)
	} else {
	    ll_word(indirect, addr);
	}
	regs[SRC_REG] += 2;	/* is this right ? */
	ll_word(addr, *data);
	return;
    case 4:
	regs[SRC_REG] -= 2;
	addr = regs[SRC_REG];
	ll_word(addr, *data);
	return;
    case 5:
	regs[SRC_REG] -= 2;
	indirect = regs[SRC_REG];
	ll_word(indirect, addr);
	ll_word(addr, *data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[SRC_REG] + indirect;
	ll_word(addr, *data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[SRC_REG] + indirect;
            ll_word(indirect, addr);
	ll_word(addr, *data);
	return;
    }
    illegal();
}


/* store_dst() - */

void 
store_dst(data)
    uint16_t data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	regs[DST_REG] = data;
	return;
    case 1:
	addr = regs[DST_REG];
	sl_word(addr, data);
	return;
    case 2:
	addr = regs[DST_REG];
	sl_word(addr, data);
	regs[DST_REG] += 2;
	return;
    case 3:
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	regs[DST_REG] += 2;	/* is this right ? */
	sl_word(addr, data);
	return;
    case 4:
	regs[DST_REG] -= 2;
	addr = regs[DST_REG];
	sl_word(addr, data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	sl_word(addr, data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	sl_word(addr, data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[DST_REG] + indirect;
            ll_word(indirect, addr);
	sl_word(addr, data);
	return;
    }
    illegal();
}


/* load_dst() */

void 
load_dst(data)
    uint16_t *data;
{
    uint16_t addr, indirect;

    switch (DST_MODE) {
    case 0:
	*data = regs[DST_REG];
	return;
    case 1:
	addr = regs[DST_REG];
	ea_addr = addr;
	if (DST_REG == PC) {
	    lli_word(addr, *data)
	} else {
	    ll_word(addr, *data);
	}
	return;
    case 2:
	addr = regs[DST_REG];
	ea_addr = addr;
	if (DST_REG == PC) {
	    lli_word(addr, *data)
	} else {
	    ll_word(addr, *data);
	}
	regs[DST_REG] += 2;
	return;
    case 3:
	indirect = regs[DST_REG];
	if (DST_REG == PC) {
	    lli_word(indirect, addr)
	} else {
	    ll_word(indirect, addr);
	}
	ea_addr = addr;
	ll_word(addr, *data);
	regs[DST_REG] += 2;
	return;
    case 4:
	regs[DST_REG] -= 2;
	addr = regs[DST_REG];
	ea_addr = addr;
	ll_word(addr, *data);
	return;
    case 5:
	regs[DST_REG] -= 2;
	indirect = regs[DST_REG];
	ll_word(indirect, addr);
	ea_addr = addr;
	ll_word(addr, *data);
	return;
    case 6:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	addr = regs[DST_REG] + indirect;
	ea_addr = addr;
	ll_word(addr, *data);
	return;
    case 7:
	lli_word(regs[PC], indirect);
	regs[PC] += 2;
	indirect = regs[DST_REG] + indirect;
            ll_word(indirect, addr);
	ea_addr = addr;
	ll_word(addr, *data);
	return;
    }
    illegal();
}


/* store_dst_2() - */

void 
store_dst_2(data)
    uint16_t data;
{
    if (DST_MODE == 0) {
	regs[DST_REG] = data;
	return;
    }
    sl_word(ea_addr, data);
}
