/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: cstrc.c,v 1.4 1998/03/12 15:43:41 harti Exp $
 */
# include <string.h>
# include <ctype.h>
# include "begemot.h"

# define GROW 100

int cstrwarn;

static unsigned char getx(char **);
static unsigned char geto(char **);

char *
cstrc(char **pp, char delim, size_t *plen)
{
	size_t alloc;
	char *str;
	unsigned char c;

	alloc = GROW;
	*plen = 0;
	str = xalloc(alloc);

	while((c = **pp) != (unsigned char)delim && c != '\0') {
		(*pp)++;
		if(c == '\\') {
			switch(c = *(*pp)++) {

			  case '\0':
				(*pp)--;
				c = '\\';
				break;

			  case '\\':
			  case '\'':
			  case '"':
				break;

			  default:
				if(cstrwarn)
					warn("unknown escape sequence '%c'", c);
				break;

			  case 'a':
				c = '\a';
				break;

			  case 'b':
				c = '\b';
				break;

			  case 'f':
				c = '\f';
				break;

			  case 'n':
				c = '\n';
				break;

			  case 'r':
				c = '\r';
				break;

			  case 't':
				c = '\t';
				break;

			  case 'v':
				c = '\v';
				break;

			  case 'x':
				if(!isascii((u_int)**pp) || !isxdigit((u_int)**pp)) {
					if(cstrwarn)
						warn("\\x used with no following hex digits");
					break;
				}
				c = getx(pp);
				break;

			  case '0': case '1': case '2': case '3':
			  case '4': case '5': case '6': case '7':
				(*pp)--;
				c = geto(pp);
				break;
			}
		}
		if(alloc == *plen) {
			alloc += GROW;
			str = xrealloc(str, alloc);
		}
		str[(*plen)++] = c;
	}

	if(alloc == *plen) {
		alloc += 1;
		str = xrealloc(str, alloc);
	}
	str[*plen] = '\0';

	return str;
}

static unsigned char
getx(char **pp)
{
	unsigned char c, ci;
	int len = 2;

	c = 0;
	while(len--) {
		ci = **pp;
		if(!isxdigit(ci))
			break;
		if(isupper(ci))
			c = (c << 4) + ci - 'A' + 10;
		else if(islower(ci))
			c = (c << 4) + ci - 'a' + 10;
		else
			c = (c << 4) + ci - '0';
		(*pp)++;
	}
	return c;
}

static unsigned char
geto(char **pp)
{
	unsigned char ci;
	unsigned c;
	int len = 3;

	c = 0;
	while(len--) {
		ci = **pp;
		if(!isdigit(ci) || ci == '8' || ci == '9')
			break;
		c = (c << 3) + ci - '0';
		(*pp)++;
	}
	if(c > 0377 && cstrwarn)
		warn("escape sequence out of range");
	return c;
}

# ifdef TEST

# include <stdio.h>
int
main(int argc, char *argv[])
{
	char *ret, *str;
	size_t len;

	cstrwarn = 1;

	str = argv[1];
	ret = cstrc(&str, '"', &len);

	fprintf(stderr, "'%s'\n", str);
	fwrite(ret, 1, len, stdout);

	return 0;
}

# endif
