#include "pdp11.h"
#include "driverint.h"

#define REG(n) (*regs[(n)])

/* grrr.  broken compiler refuses to accept 8 in the brackets - won't elide null per K&Rv2 */
static char byteaidinc[/*8*/] = "\1\1\1\1\1\1\2\2"; /* 2 for r6/r7, 1 for others */

static pagedesc nomap_pd[8] = { { 0000000, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0000200, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0000400, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0000600, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0001000, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0001200, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0001400, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE },
				{ 0177600, (0177 << PDR_LEN_SHIFT) | PDR_ACC_READWRITE } };

static unsigned long int pacache[2][1024];
#define PAC_VALID 0x80000000
#define PAC_WRITE 0x40000000
#define PAC_LENOK 0x20000000
#define PAC_PA    0x1fffe000
#define PAC_PA_SHIFT 7 /* shifts into position, not shift clear to lsb */
#define PAC_PDX   0x000007ff
static pagedesc *pac_pd[2*1024];

#define YSTACKCHK(rno) (((rno) == 6) && (pswc_cm == MODE_K) && (sp < 0400) && yellow_stack())


void nonresident();

int sxb(b)
byte b;
{
 return((b&0x80)?(b|((~0)<<8)):b);
}

int sxw(w)
word w;
{
 return((w&0x8000)?(w|((~0)<<16)):w);
}

void clearpac()
{
 register int i;
 register int j;

 for (i=0;i<2;i++) for (j=0;j<8;j++) pacache[i][j] = 0;
}

void clear1pac(as,inx)
ASPACE as;
int inx;
{
 bzero((char *)&pacache[(int)as][inx<<7],(1<<7)*sizeof(pacache[0][0]));
}

static pagedesc *vtopd(va,as)
word va;
ASPACE as;
{
 pagedesc *pd;

 pd = &nomap_pd[0];
 if (mmr0 & MMR0_MM_ENB)
  { static int mmr3bit[4] = { MMR3_MAPEN_K, MMR3_MAPEN_S, 0, MMR3_MAPEN_U };
    if (pswc_cm == MODE_X) nonresident(va,as);
    if ((mmr3 & mmr3bit[pswc_cm]) == 0) as = MMAN_ISPACE;
    pd = &pdesc[pswc_cm][(int)as][0];
  }
 pd += va >> 13;
 return(pd);
}

static unsigned long int getpac(va,as)
register word va;
register ASPACE as;
{
 register pagedesc *pd;
 register unsigned long int pac;
 register int l;
 register int i;
 register int x;

 pd = vtopd(va,as);
 switch (pd->pdr & PDR_ACC)
  { case PDR_ACC_READONLY:
       pac = PAC_VALID | (pd->par << (6+PAC_PA_SHIFT));
       break;
    case PDR_ACC_READWRITE:
       pac = PAC_VALID | PAC_WRITE | (pd->par << (6+PAC_PA_SHIFT));
       break;
    default:
       nonresident(va,as);
       break;
  }
 x = (va & 0xe000) >> 6;
 pac |= (((int)as) << 10) | x;
 l = (pd->pdr & PDR_LEN) >> PDR_LEN_SHIFT;
 if (pd->pdr & PDR_ED)
  { for (i=0;i<l;i++)
     { pacache[(int)as][x] = pac;
       pac_pd[pac&PAC_PDX] = pd;
       x ++;
       pac += (1 << (6+PAC_PA_SHIFT)) + 1;
     }
    pac |= PAC_LENOK;
    for (;i<0200;i++)
     { pacache[(int)as][x] = pac;
       pac_pd[pac&PAC_PDX] = pd;
       x ++;
       pac += (1 << (6+PAC_PA_SHIFT)) + 1;
     }
  }
 else
  { pac += 0177 * ((1 << (6+PAC_PA_SHIFT)) + 1);
    x += 0177;
    for (i=0177;i>l;i--)
     { pacache[(int)as][x] = pac;
       pac_pd[pac&PAC_PDX] = pd;
       x --;
       pac -= (1 << (6+PAC_PA_SHIFT)) + 1;
     }
    pac |= PAC_LENOK;
    for (;i>=0;i--)
     { pacache[(int)as][x] = pac;
       pac_pd[pac&PAC_PDX] = pd;
       x --;
       pac -= (1 << (6+PAC_PA_SHIFT)) + 1;
     }
  }
 return(pacache[(int)as][va>>6]);
}

/*
 if (pd->pdr & PDR_ED)
  {  if (((va >> 6) & 0177) < ((pd->pdr & PDR_LEN) >> PDR_LEN_SHIFT)) lengtherror(va,as);
  }
 else
  {  if (((va >> 6) & 0177) > ((pd->pdr & PDR_LEN) >> PDR_LEN_SHIFT)) lengtherror(va,as);
  }
*/
#define PACVA_TO_PA(pac,va) (((pac&PAC_PA)>>PAC_PA_SHIFT)+(va&0x3f))
#define GETPA(va,as,pa)   ( (((pa=pacache[(int)as][va>>6])&PAC_VALID)||(pa=getpac(va,as))),	\
			    ((pa&PAC_LENOK)||lengtherror(va,as)),				\
			    (pa=PACVA_TO_PA(pa,va)) )
#define GETPA_W(va,as,pa) ( (((pa=pacache[(int)as][va>>6])&PAC_VALID)||(pa=getpac(va,as))),	\
			    ((pa&PAC_WRITE)||readonly(va,as)),					\
			    ((pa&PAC_LENOK)||lengtherror(va,as)),				\
			    (pac_pd[pa&PAC_PDX]->pdr|=PDR_W),					\
			    (pa=PACVA_TO_PA(pa,va)) )

static int lengtherror(va,as)
word va;
ASPACE as;
{
 if (! MMR_FROZEN)
  { mmr0 = (mmr0 & ~(MMR0_ACCMODE|MMR0_ID_SPACE|MMR0_PAGENO)) |
	(pswc_cm << MMR0_ACCMODE_SHIFT) |
	(((int)as) << MMR0_ID_SPACE_SHIFT) |
	((va >> 13) << MMR0_PAGENO_SHIFT);
  }
 mmr0 |= MMR0_LEN_ERR;
 trapto(0250);
}

static void nonresident(va,as)
word va;
ASPACE as;
{
 if (! MMR_FROZEN)
  { mmr0 = (mmr0 & ~(MMR0_ACCMODE|MMR0_ID_SPACE|MMR0_PAGENO)) |
	(pswc_cm << MMR0_ACCMODE_SHIFT) |
	(((int)as) << MMR0_ID_SPACE_SHIFT) |
	((va >> 13) << MMR0_PAGENO_SHIFT);
  }
 mmr0 |= MMR0_NONRES;
 trapto(0250);
}

static int readonly(va,as)
word va;
ASPACE as;
{
 if (! MMR_FROZEN)
  { mmr0 = (mmr0 & ~(MMR0_ACCMODE|MMR0_ID_SPACE|MMR0_PAGENO)) |
	(pswc_cm << MMR0_ACCMODE_SHIFT) |
	(((int)as) << MMR0_ID_SPACE_SHIFT) |
	((va >> 13) << MMR0_PAGENO_SHIFT);
  }
 mmr0 |= MMR0_RO_ERR;
 trapto(0250);
}

static void oddaddress(va,as)
word va;
ASPACE as;
{
 cpu_error |= CPUERR_ADDR_ERR;
 trapto(4);
}

static void bustimeout(pa,as)
int pa;
ASPACE as;
{
 if ((pa & 017760000) == 017760000)
  { cpu_error |= CPUERR_IO_TIMO;
  }
 else
  { cpu_error |= CPUERR_NXM_ERR;
  }
 trapto(4);
}

static void illregister()
{
 trapto(4);
}

static int yellow_stack()
{
 pending |= PEND_YSTACK;
}

static void chgreg(rno,chg)
int rno;
int chg;
{
 int mmr1_bits;

 REG(rno) += chg;
 if (MMR_FROZEN) return;
 mmr1_bits = ((chg & 037) << 3) | rno;
 if (mmr1 & 0xff)
  { mmr1 |= mmr1_bits << 8;
  }
 else
  { mmr1 |= mmr1_bits;
  }
}

word fetchphys(pa)
register unsigned long int pa;
{
 pa &= ~1;
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa];
    if (! d) bustimeout(pa|017760000,MMAN_DSPACE);
    return((*d->io)(d,pa,IO_R,0,NOFXN));
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,MMAN_DSPACE);
#endif
 return(core[pa]|(core[pa+1]<<8));
}

void storephys(pa,w)
register unsigned long int pa;
register word w;
{
 pa &= ~1;
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa];
    if (! d) bustimeout(pa|017760000,MMAN_DSPACE);
    (*d->io)(d,pa,IO_W,w,NOFXN);
    return;
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,MMAN_DSPACE);
#endif
 core[pa] = w & 0xff;
 core[pa+1] = (w >> 8) & 0xff;
}

word fetchword(va,as)
register word va;
ASPACE as;
{
 register unsigned long int pa;

 if (va & 1) oddaddress(va,as);
 GETPA(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa];
    if (! d) bustimeout(pa|017760000,as);
    return((*d->io)(d,pa,IO_R,0,NOFXN));
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 return(core[pa]|(core[pa+1]<<8));
}

static byte fetchbyte(va,as)
register word va;
ASPACE as;
{
 register unsigned long int pa;

 GETPA(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    word w;
    pa &= 8191;
    d = drivermask[pa&~1];
    if (! d) bustimeout(pa|017760000,as);
    w = (*d->io)(d,pa&~1,IO_R,0,NOFXN);
    return(((pa&1)?(w>>8):w)&0xff);
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 return(core[pa]);
}

void storeword(va,as,w)
register word va;
ASPACE as;
register word w;
{
 register unsigned long int pa;

 if (va & 1) oddaddress(va,as);
 GETPA_W(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa];
    if (! d) bustimeout(pa|017760000,as);
    (*d->io)(d,pa,IO_W,w,NOFXN);
    return;
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 core[pa] = w & 0xff;
 core[pa+1] = (w >> 8) & 0xff;
}

static void storebyte(va,as,b)
register word va;
ASPACE as;
byte b;
{
 register unsigned long int pa;

 GETPA_W(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa&~1];
    if (! d) bustimeout(pa|017760000,as);
    (*d->io)(d,pa,IO_W|IO_BYTE,b,NOFXN);
    return;
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 core[pa] = b;
}

static void rmw_word(va,as,fxn)
register word va;
ASPACE as;
void (*fxn)();
{
 register unsigned long int pa;
 word w;

 if (va & 1) oddaddress(va,as);
 GETPA_W(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa];
    if (! d) bustimeout(pa|017760000,as);
    if (d->flags & DVR_NORMW)
     { w = (*d->io)(d,pa,IO_R,0,NOFXN);
       (*fxn)(&w);
       (*d->io)(d,pa,IO_W,w,NOFXN);
     }
    else
     { (*d->io)(d,pa,IO_RMW,0,fxn);
     }
    return;
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 w = core[pa] | (core[pa+1] << 8);
 (*fxn)(&w);
 core[pa] = w & 0xff;
 core[pa+1] = (w >> 8) & 0xff;
}

static void rmw_byte(va,as,fxn)
register word va;
ASPACE as;
void (*fxn)();
{
 register unsigned long int pa;
 byte b;

 GETPA_W(va,as,pa);
 if ((pa & 017760000) == 017760000)
  { DRIVER *d;
    pa &= 8191;
    d = drivermask[pa&~1];
    if (! d) bustimeout(pa|017760000,as);
    if (d->flags & DVR_NORMW)
     { word w;
       w = (*d->io)(d,pa&~1,IO_R,0,NOFXN);
       b = ((pa&1)?(w>>8):w) & 0xff;
       (*fxn)(&b);
       (*d->io)(d,pa,IO_W|IO_BYTE,b,NOFXN);
     }
    else
     { (*d->io)(d,pa,IO_RMW|IO_BYTE,0,fxn);
     }
    return;
  }
#if CORESIZE < 020000000-8192
 if (pa >= CORESIZE) bustimeout(pa,as);
#endif
 b = core[pa];
 (*fxn)(&b);
 core[pa] = b & 0xff;
}

int reg_access(loc,rp,op,fixedbits,data)
int loc;
word *rp;
int op;
word fixedbits;
word data;
{
 switch (op & IO_OP)
  { case IO_R:
       return(*rp);
       break;
    case IO_W:
       if (op & IO_BYTE)
	{ if (loc & 1)
	   { *rp = (*rp & (fixedbits|0x00ff)) | ((data << 8) & 0xff00 & ~fixedbits);
	   }
	  else
	   { *rp = (*rp & (fixedbits|0xff00)) | (data & 0x00ff & ~fixedbits);
	   }
	}
       else
	{ *rp = (*rp & fixedbits) | (data & ~fixedbits);
	}
       break;
  }
 return(0); /* keep picky compilers happy */
}

/* should sp_push and sp_pop use chgreg()? */

word sp_pop()
{
 word a;

 if ((pswc_cm == MODE_K) && (sp < 0400)) yellow_stack();
 a = sp;
 sp += 2;
 return(fetchword(a,MMAN_DSPACE));
}

void sp_push(w)
word w;
{
 sp -= 2;
 if ((pswc_cm == MODE_K) && (sp < 0400)) yellow_stack();
 storeword(sp,MMAN_DSPACE,w);
}

word get_operand_a(op)
int op;
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       illregister();
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       return(REG(rno));
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  return(a);
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  return(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       return(REG(rno));
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       return(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(REG(rno)+x);
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
  }
}

word get_operand_w(op)
int op;
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       return(REG(rno));
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       return(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  return(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  return(fetchword(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       return(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       return(fetchword(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(fetchword(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
	}
       break;
  }
}

byte get_operand_b(op)
int op;
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       return(0xff&REG(rno));
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       return(fetchbyte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,byteaidinc[rno]);
	  return(fetchbyte(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  return(fetchbyte(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-(int)byteaidinc[rno]);
       return(fetchbyte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       return(fetchbyte(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(fetchbyte(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE));
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  return(fetchbyte(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE));
	}
       break;
  }
}

void set_operand_w(op,value)
int op;
word value;
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       REG(rno) = value;
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       storeword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  storeword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  storeword(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       storeword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       storeword(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  storeword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  storeword(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
	}
       break;
  }
}

void set_operand_b(op,value)
int op;
byte value;
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       REG(rno) = (REG(rno) & 0xff00) | value;
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       storebyte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,byteaidinc[rno]);
	  storebyte(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  storebyte(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-(int)byteaidinc[rno]);
       storebyte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       storebyte(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  storebyte(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,value);
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  storebyte(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,value);
	}
       break;
  }
}

void rmw_operand_w(op,fxn)
int op;
void (*fxn)();
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
       (*fxn)(&REG(rno));
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       rmw_word(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  rmw_word(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  rmw_word(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       rmw_word(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       rmw_word(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  rmw_word(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  rmw_word(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
	}
       break;
  }
}

void rmw_operand_b(op,fxn)
int op;
void (*fxn)();
{
 register int rno;

 rno = op & 7;
 switch ((op >> 3) & 7)
  { case 0: /* Rn */
	{ /* not register */ byte b;
	  b = REG(rno);
	  (*fxn)(&b);
	  REG(rno) = (REG(rno) & 0xff00) | b;
	}
       break;
    case 1: /* (Rn) */
       YSTACKCHK(rno);
       rmw_byte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
       break;
    case 2: /* (Rn)+, #X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,byteaidinc[rno]);
	  rmw_byte(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
	}
       break;
    case 3: /* @(Rn)+, @#X */
	{ register word a;
	  YSTACKCHK(rno);
	  a = REG(rno);
	  chgreg(rno,2);
	  rmw_byte(fetchword(a,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
	}
       break;
    case 4: /* -(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-(int)byteaidinc[rno]);
       rmw_byte(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
       break;
    case 5: /* @-(Rn) */
       YSTACKCHK(rno);
       chgreg(rno,-2);
       rmw_byte(fetchword(REG(rno),(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
       break;
    case 6: /* X(Rn), X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  rmw_byte(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE,fxn);
	}
       break;
    case 7: /* @X(Rn), @X */
	{ register word x;
	  YSTACKCHK(rno);
	  x = fetchword(pc,MMAN_ISPACE);
	  chgreg(7,2);
	  rmw_byte(fetchword(REG(rno)+x,(rno==7)?MMAN_ISPACE:MMAN_DSPACE),MMAN_DSPACE,fxn);
	}
       break;
  }
}
