/* lp11 driver module */

#include "pdp11.h"
#include "driver.h"

#define BASE 017777514
#define LPS (BASE+0)
#define LPB (BASE+2)

extern DRIVER lp11_driver;

static word lps;
#define LPS_IE    0000100
#define LPS_DONE  0000200
#define LPS_ERROR 0100000
#define LPS_MBZ   0077477
#define LPS_READONLY (LPS_ERROR|LPS_DONE)
static word lpb;

static void havedata()
{
 if (lps & LPS_IE) interrupt(&lp11_driver,0200,BR4);
}

static void lp11_init(d,iomask)
DRIVER *d;
char *iomask;
{
 int i;

 iomask[IOMASK(LPS)] = 1;
 iomask[IOMASK(LPB)] = 1;
}

static int lp11_io(d,loc,op,data,fxn)
DRIVER *d;
int loc;
int op;
int data;
void (*fxn)();
{
 switch (loc)
  { case IOMASK(LPS):
       switch (op & IO_OP)
	{ case IO_R:
	     return(lps);
	     break;
	  case IO_W:
	     data &= ~(LPS_MBZ|LPS_READONLY);
	     if (op & IO_BYTE)
	      { lps = (lps & 0xff00) | (data & 0xff);
	      }
	     else
	      { lps = data;
	      }
	     break;
	}
       break;
    case IOMASK(LPB):
       switch (op & IO_OP)
	{ case IO_R:
	     return(0);
	     break;
	  case IO_W:
	     lpb = data & 0x7f;
	     havedata();
	     break;
	}
       break;
  }
}

static void lp11_busreset(d)
DRIVER *d;
{
 lps &= ~LPS_IE;
}

static void lp11_reset(d)
DRIVER *d;
{
}

static void lp11_intack(irq)
INTRQ *irq;
{
}

DRIVER lp11_driver = { DVR_NORMW, "LP11", lp11_init, 0, lp11_io, lp11_busreset, lp11_reset, lp11_intack };
