/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: epp.h,v 1.8 2000/03/04 08:04:03 hbb Exp $ */

/*
 * definitions for EPP support
 */
# include <stdio.h>
# include <stdlib.h>
# include <signal.h>
# include <stdarg.h>
# include <string.h>
# include <errno.h>
# include <unistd.h>
# include <fcntl.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/mman.h>
# include <sys/uio.h>
# include <sys/time.h>

# include <begemot.h>
# include "cdefs.h"
# include "eppdefs.h"
# include "qna_regs.h"
# include "util.h"


typedef struct Filter	Filter;

struct Filter {
	int	promisc;	/* promiscuous mode */
	int	allmulti;	/* receive all multicast frames */
	uint	naddr;		/* number of regular addresses */
	u_char	addr[14][6];	/* addresses */
};


extern char	*progname;	/* program name */
extern uint	rcv_enable;	/* receiver is enabled */
extern Comm	*comm;		/* shared memory area */
extern int	fd;		/* input file descriptor */
extern sigset_t	allmask;	/* all used signals */

extern u_char	xbuf[];		/* transmit buffer */
extern u_int	xlen;		/* transmit frame size */

extern Filter	f;		/* the filter */

/*
 * support functions
 */
void	loop() DEAD_FUNC;
void	init_sigs();
void	open_shmem();
void	p11_write(u_int, void *p, u_int len);
int	apply_filter(u_char *);


/*
 * functions called from support functions
 */
int	input_filter(u_char *);		/* return TRUE if input packet ok */
void	set_filter();			/* setup new filter */
void	transmit();			/* transmit frame */
u_int	read_input(u_char **, int *);	/* read input frame */
void	do_info(char *buf);		/* monitor 'info' command */
void	reset();			/* reset all */
void	rcv_enable_change();		/* state changed */
void	parse_ether(u_char *, char *);
