/*
 * Copyright (c) 1999 Maksim Yevmenkin <m_evmenkin@yahoo.com>
 *                                     <evmax@earthlink.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * BASED ON:
 * -------------------------------------------------------------------------
 *
 * Copyright (c) 1998 Brian Somers <brian@Awfulhak.org>
 * All rights reserved.
 *
 *	$Id: if_tunvar.h,v 1.3 1998/11/11 10:56:05 truckman Exp $
 */

#ifndef _NET_IF_TAPVAR_H_
#define _NET_IF_TAPVAR_H_

struct tap_softc {
	struct arpcom	arpcom;			/* ethernet common data      */
#define tap_if		arpcom.ac_if

	u_short		tap_flags;		/* misc flags                */
#define	TAP_OPEN	0x0001
#define	TAP_INITED	0x0002
#define	TAP_RCOLL	0x0004
#define	TAP_IASET	0x0008
#define	TAP_DSTADDR	0x0010
#define	TAP_RWAIT	0x0040
#define	TAP_ASYNC	0x0080
#define TAP_READY       (TAP_OPEN|TAP_INITED)

	struct sigio	*tap_sigio;		/* information for async I/O */
	struct selinfo	 tap_rsel;		/* read select               */
	struct selinfo	 tap_wsel;		/* write select (not used)   */

	struct ifqueue	 if_rcv;		/* receive queue             */

#ifdef	DEVFS
	void		*tap_devfs_token;	/* DEVFS stuff               */
#endif
};

#endif /* !_NET_IF_TAPVAR_H_ */
