/* include file for v6 unix to 4.2 file system conversion  */
/* cater for different word sizes */
#ifdef UNIX4.2
#endif


/* v6 super block structure    */
struct t_sblock {
    unsigned short isize;    /* number of 512 blocks devoted to ther i-list */
    unsigned short fsize;  /* first block number not available for allocation */
    unsigned short nfree;   /* Number of free free		 	   */
    unsigned short free[100];  /* pointers to free blocks free[0] is head of free chain*/
    unsigned short ninode;
    unsigned short inode[100];
    char flock;		
    char ilock;	
    char fmod;
    unsigned short  time[2];
} sblock;

#define	s_isize	sblock.isize
#define s_fsize	sblock.fsize
#define s_nfree	sblock.nfree
#define s_free	sblock.free
#define s_ninode sblock.ninode
#define s_inode	sblock.inode
#define s_flock	sblock.flock
#define s_ilock	sblock.ilock
#define s_fmod	sblock.fmod
#define s_time  sblock.time


/*	inode structure 	*/

struct t_inode	{
    unsigned short		flags;
    char    nlinks;		/* number of links to file		*/
    char    uid;		/* uid of owner				*/
    char    gid;		/* gid of owner				*/
    char    size0;		/* high byte of 24 bit size		*/
    unsigned short size1;	/* low word of 24 bit size  		*/
    unsigned short addr[8];	/* block numbers or device numbers	 */

	 /*	time of last access		*/
	 /*	time of last modification */


     unsigned short	actime[2];	
     unsigned short	modtime[2];		

/*	unsigned long	actime;
	unsigned long	modtime;
*/
} ;

#define	i_flags	inode.flags
#define i_nlinks inode.nlinks
#define i_uid	inode.uid
#define i_gid	inode.gid
#define i_size	inode.size0
#define i_size1	inode.size1
#define i_addr	inode.addr
#define i_actime inode.actime
#define i_modtime inode.modtime

/*	Flag definitions		*/


#define	IALLOC		0100000		/* inode allocated		*/
#define	IPLANE		0000000		/* plane file mask		*/
#define	IDIREC		0040000		/* directory file mask		*/
#define	ICHAR		0020000		/* character special file mask	*/
#define	IBLOCK		0060000		/* block special mask		*/
#define	ILARGE		0010000		/* large file			*/
#define	ISETUI		0004000		/* setuid			*/
#define	ISETGI		0002000		/* getuid			*/
#define	IUREAD		0000400		/* read				*/
#define	IUWRITE		0000200		/*	owner write		*/
#define	IUEXEC		0000100		/* owner execute		*/
#define	IGREAD		0000040		/* group read			*/
#define	IGWRITE		0000020		/* group write			*/
#define	IGEXEC		0000010		/* group exec			*/
#define	IOREAD		0000004		/*other read			*/
#define	IOWRITE		0000002		/* other write			*/
#define	IOEXEC		0000001		/* other exec			*/


#define	M_OWN		0000700		/*  owner mask			*/
#define	M_GRP		0000070		/*  group mask			*/
#define	M_OTR		0000007		/*  other mask			*/
#define	M_TYP		0060000		/*  file type mask		*/
#define	M_SPL		0060000		/*  special file mask		*/

#define	SOFFSET	512
#define	SBSIZE	512

struct t_dir {
    unsigned short  ip;	 		 /* inode number of the entry	*/
    char fname[13];			 /* 14 character filename	*/
} ;

