/*
 * Apollo specific news code.
 *
 * Jim Rees Apollo Computer
 */

#include "iparams.h"
#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/error.ins.c"

#define INTERVAL	2	/* No. of seconds between lock retries */

int lockcount;			/* Shared with ifuncs.c */

extern std_$call error_$get_string();
extern std_$call file_$force_unlock();
extern std_$call name_$resolve();

FILE *
actfopen(fname)
char *fname;
{
	int i, fd;
	char errbuf[100], buf[120];
	short errlen;
	status_$t st;

	for (i = 0; i < DEADTIME; i += INTERVAL) {
		fd = ios_$open(*fname, (short) strlen(fname), ios_$read_intend_write_opt, st);
		if (st.all == status_$ok)
			return fdopen(fd, "r+");
		if (st.all == ios_$concurrency_violation)
			sleep(INTERVAL);
		else {
			error_$get_string(st, errbuf, (short) sizeof errbuf, errlen);
			sprintf(buf, "%s: %.*s", fname, errlen, errbuf);
			xerror(buf);
		}
	}
	xerror("Can't acquire read lock");
}

lock()
{
	int i;
	status_$t st;
	char errbuf[100], buf[120];
	short errlen;

	if (lockcount++ != 0)
		return;
	for (i = 0; i < DEADTIME; i += INTERVAL) {
		ios_$set_conn_flag((ios_$id_t) fileno(actfp), ios_$cf_write, true, st);
		if (st.all == status_$ok)
			return;
		if (st.all == ios_$concurrency_violation)
			sleep(INTERVAL);
		else {
			error_$get_string(st, errbuf, (short) sizeof errbuf, errlen);
			sprintf(buf, "%s: %.*s", ACTIVE, errlen, errbuf);
			xerror(buf);
		}
	}
	xerror("Can't acquire write lock");
}

unlock()
{
	status_$t st;

	if (lockcount <= 0)
		lockcount = 1;
	if (--lockcount != 0)
		return;
	if (actfp != NULL)
		ios_$set_conn_flag((ios_$id_t) fileno(actfp), ios_$cf_write, false, st);
}

force_unlock_dir(file)
char *file;
{
	char *cp;
	short len;
	uid_$t uid;
	status_$t st;

	if ((cp = rindex(file, '/')) != NULL)
		len = cp - file;
	else
		len = strlen(file);
	name_$resolve(*file, len, uid, st);
	if (st.all != status_$ok)
		return;
	file_$force_unlock(uid, st);
	if (st.all == status_$ok)
		logerr("Force-unlocked %.*s", len, file);
}

/*
 * Given our current batching scheme, article locking seems
 * unnecessary and just slows us down.
 */

idlock(str)
char *str;
{
}

idunlock()
{
}

getident(hp)
struct hbuf *hp;
{
	uid_$t uid;
	extern std_$call uid_$gen();

	uid_$gen(uid);
	sprintf(hp->ident, "<%lx.%lx@%s>",
	    uid.high, uid.low & 0xfffff, LOCALSYSNAME);
}
