#!/bin/sh
#
#* ------------------------------------------------------------------------- */
#*                             AUTHOR :                                      */
#* ------------------------------------------------------------------------- */
#* J"org Weule                       Mathematisches Institut der             */ 
#*                                   Heinrich-Heine-Universitaet Duesseldorf */
#* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
#* ------------------------------------------------------------------------- */
#* Permission to use, copy, modify and distribute this software for any      */
#* purpose and without fee is hereby granted, provided that this copyright   */
#* notice appear in all copies as well as supporting documentation. All      */
#* work developed as a consequence of the use of this program should duly    */
#* acknowledge such use.                                                     */
#* ------------------------------------------------------------------------- */
#
# This command file builds the ddf for the driver of the 
# parallel I/O-card
#
# adress space of the device:
ADR="1f0 1f7"
#
# intererupt level:
I=9
#
# additional flags
O=-share
#D=-display
#
/com/dlf driver.ddf
/com/crddf driver.ddf - <<! 
-at $O
-unit $I
-csr_page $ADR
-node *
-call_library           driver.lib
-interrupt_library      driver_int.lib
-initialization_routine printer_startup
-cleanup_routine        printer_cleanup
-interrupt_routine $I   printer_interrupt
$D -end
!

