
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */ 
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */
/* Permission to use, copy, modify and distribute this software for any      */
/* purpose and without fee is hereby granted, provided that this copyright   */
/* notice appear in all copies as well as supporting documentation. All      */
/* work developed as a consequence of the use of this program should duly    */
/* acknowledge such use.                                                     */
/* ------------------------------------------------------------------------- */

/*
 * Here we are initializing our hardware:
 *
 * The pointer we got pooits to lower adress of our ddf-file and we
 * return the adress of the pointer we have to write the bytes to.
 *
 * Note that all these adresses have to be in an area, in witch you can only
 * devide the lowest adress by eight. I don't want to explain the adressing
 * of the mashine at this point.
 *
 * You can also call the routine with a zero pointer.
 */

#include "printer.h"

/*-------------change-for-your-device----------------------------------------*/
typedef struct { char PortA , PortB , Control } volatile device_t;
/*---------------------------------------------------------------------------*/

static device_t *base_adr = (device_t*)0 ;

reg* printer_start(reg*p){
	int i;

	if ( p != (void*)0 ) base_adr = (device_t*)p ;

#ifdef SPE
	/* initialize the spe */
	base_adr->Control = 0x10 ; /* Inta set */
#else
	/* initialize the 8255 */
	/* Port A : output / hadshake
	 * Port B : input
	 * set inta
	 */
	base_adr->Control = 0xa3 ; /* Port1 auf -a o -ma 1 -b o -mb 0  */
	base_adr->Control = 0x0d ; /* Inta set */
#endif

	return &(base_adr->PortA) ;
}

void printer_end(void) {  
	base_adr->Control = 0x00 ; /* Port1 auf Input */
}

unsigned char printer_status(void) {
#ifdef SPE
	return base_adr->PortB ;
#endif
}
                                         
/* returns not NULL iff paper empty */
unsigned char printer_paper_empty(void) {
#ifdef SPE
	return base_adr->PortB & 0x20 ;
#else
	return 0;
#endif
}
