
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */ 
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */
/* Permission to use, copy, modify and distribute this software for any      */
/* purpose and without fee is hereby granted, provided that this copyright   */
/* notice appear in all copies as well as supporting documentation. All      */
/* work developed as a consequence of the use of this program should duly    */
/* acknowledge such use.                                                     */
/* ------------------------------------------------------------------------- */

#include <apollo/base.h>
#include <apollo/pbu.h>
#define PRINTER_KERNEL
#include "printer.h"


		/* register to write to and base address */
reg	*printer_port = (reg*)0 ;
		/* unit number */
pbu_$unit_t
	printer_unit = 7 ;
		/* ring buffer with the pointers next and last */
char	printer_buffer[MAX] ;
int	printer_next = 0 ;
int	printer_last = 0 ;
		/* If the buffer is full, the driver waits for an
		 * ec-advance. It is send after po.z bytes.
		 */
int	printer_wakeup = 0 ;
		/* disable wird von der Interruptroutine auf 1 gesetzt,
		 * wenn der Puffer leer ist. Die Puffer-fuell-Routine
		 * enablelt dann wieder die Interrupts, setzt dis auf 0
		 * und startet dann wie Uebertragung durch fuellen des
		 * PIO-Portes A.
		 */
		/* disable is set to  1 by the interrupt routine,
		 * if the buffer is empty. The pio_put routine will
                 * enable the inerrunpts, set the variable to 0 and 
                 * starts the transmission again.
                 * z is like a semaphore
		 */
int	printer_disable = 1 ;
		/* PS-files are closing with EOF
		 * we count the charaters in this situation
		 */
int	printer_count = 0 ;
int	printer_last_eof = 0 ;
int	printer_count_jobs = 0 ;
int	printer_no_int ;

/****************
		*
		*	write one character to get new interrupts
		*
		**************************************************************/
/* write one char to the device */
void printer_write_char(void){
		/* after adding 1 to next, next may have a value not valid
		 * for indexing the array, the test of (last==next) in the
		 * write routine will fail in this case.
		 * We must copy the value, increment an adjust the value
		 * before writing it back.
		 */
	int  i = printer_next ;
	char c = printer_buffer[i] ;
#ifdef SPE
	reg register *pio = printer_port ;
#define printer_port pio
	printer_port[0] = c ;
	/* the next line must be executed before the interrupt occurs */
	i++ ; i &=  ( MAX - 1 ) ; printer_next = i ;
	/* after the following line we will get the in the interrupt */
	printer_port[2] = E_INT | STROBE ;
	/* wait now for BUSY */
	if ( BUSY ) if ( BUSY ) if ( BUSY ) if ( BUSY ) ;
	/* clear strobe */
	printer_port[2] = E_INT ;
#undef printer_port
#else
	/* the next line must be executed before the interrupt occurs */
	i++ ; i &=  ( MAX - 1 ) ; printer_next = i ;
	printer_port[0] = c ;
#endif
}
/****************
		*
		*	handle the interrupt
		*
		**************************************************************/
pbu_$interrupt_return_t printer_interrupt(void) {
	char c ;
	int  d ;

	if ( printer_next != printer_last ) {
		/*
		 * there are more characters ( at least one )
		 */
		printer_write_char();
		/*
		 * wakeup for the pio_driver ?
                 */
		if ( printer_wakeup > 0 ) if ( (--printer_wakeup) == 0 ) {
			return pbu_$interrupt_advance | pbu_$interrupt_enable ;
		}
		return pbu_$interrupt_enable ;
	} {
		/* The buffer is now empty.
		 * If the buffer is filled with some characters,
		 * the routine printer_write_char() is used to write the next
		 * character to the device.
		 */
		printer_disable = 1 ;
		return 0 ;
	}
}
/****************
		*
		*	write n characters without interrupts
		*
		**************************************************************/
printer_write_n_chars(char*p,int count){
#ifdef SPE
	reg register *pio = printer_port ;
#define printer_port pio
	do ; while ( printer_next != printer_last );
	do {
		(*printer_port) = *p ; p++ ;
		do ; while ( ACK ) ;
		*(printer_port+2) = STROBE ;

		/* wait now for BUSY - but not too long -- no loop */
		if ( BUSY ) if ( BUSY ) if ( BUSY ) if( BUSY ) ;
		*(printer_port+2) = 0x00 ; /* clear STROBE */

		do ; while ( BUSY ) ;
	} while ( (--count) > 0 ) ;
#undef printer_port
#endif
}

