/****************
		*
		*	copy the charaters into the buffer
		*
		**************************************************************/
void printer_put(char*p,int *ll){

	status_$t		status ;
	pbu_$wait_index_t	index ;
	int			count = (*ll) ;
	int			last = printer_last ;

#ifdef SPE
	if ( printer_no_int ) {
		do ; while ( printer_next != printer_last );
		do {
			(*printer_port) = *p ; p++ ;
			do ; while ( ACK ) ;
			*(printer_port+2) = STROBE ;

			/* wait now for BUSY - but not too long */
			if ( BUSY ) {
				if ( BUSY ) {
					if ( BUSY ) {
						if( BUSY ) ;
					}
				}
			}
			*(printer_port+2) = 0x00 ; /* clear STROBE */

			do ; while ( BUSY ) ;
		} while ( (--count) > 0 ) ;
#ifdef PS
		printer_count += *ll ;
		if ( p[-1] == (char)4 ) {
			printer_count_jobs ++ ;
			printer_last_eof = printer_count ;
		}
#endif
		if ( count <= 0 ) return ;
	}
#endif

	while( printer_paper_empty() ) sleep(30);
	do {
		/* Berechnung der freien Plaetze im Puffer.
		 */
		int free = ( printer_next - last - 1 ) & ( MAX - 1 ) ;
		/* free liegt nun im Intervall [0..MAX-1]
		 */
		if ( count <= free ) {
			/* Da die Zwischenergebnisse von po.b nicht 
			 * allgemien gueltig sind, wird hier mit der
			 * Hilfsvariablen d gerechnet.
			 * Nachdem d dann auf das Ende der Zeichen zeigt,
			 * wird d wieder nach po.b geladen.
			 */
#ifdef PS
			printer_count += count ;
#endif
			do {
				printer_buffer[last] = *p ; p++ ;
				/* increment and adjust */
				last ++ ; last &= ( MAX - 1 ) ;
				/* write back */
				printer_last = last ;
			} while ( --count ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
			if ( printer_disable == 1 ) printer_enable();
			return ;
		}

		/*
		 * writing some bytes into the buffer
		 */
		if ( free > 0 ) {
			int n = free ;
			if ( n > count ) n = count ;
			if ( n > LIMIT ) n = LIMIT ;
			count -= n ;
#ifdef PS
			printer_count += n ;
#endif
			do {
				printer_buffer[last] = *p ; p++ ;
				last ++ ; last &= ( MAX - 1 ) ;
				printer_last = last ;
			} while ( --n ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
		}
		/*
		 * wake up the interrupt routine - if needed
		 */
		if ( printer_disable == 1 ) printer_enable();
		/*
		 * writing more bytes into the buffer
		 */
		while ( (free=(printer_next-last-1)&(MAX-1)) > LIMIT ) {
			int n = free ;
			if ( n > count ) n = count ;
			count -= n ;
#ifdef PS
			printer_count += n ;
#endif
			do {
				printer_buffer[last] = *p++ ;
				last ++ ; last &= ( MAX - 1 ) ;
				printer_last = last ;
			} while ( --n ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
			/*
			 * wake up the interrupt routine - if needed
			 */
			if ( printer_disable == 1 ) printer_enable();
			/*
			 * ready ?
			 */
			if ( count == 0 ) return ;
		}
		/*
		 * wakeup after wakeup bytes
		 */
		if ( count > 0 ) {
			printer_wakeup = count ;
			if ( printer_wakeup > ( MAX >> 1 ) )
				printer_wakeup = ( MAX >> 1 ) ;
			if ( printer_wakeup < ( MAX >> 4 ) )
				printer_wakeup = ( MAX >> 4 ) ;
		}
		/*
		 * wake up the interrupt routine - if needed
		 */
		if ( printer_disable == 1 ) printer_enable();
		/*
		 * wait for ec-advance - if needed
		 */
		if ( count > 0 ) {
			pbu_$wait( printer_unit, 1000, true, &status );
		}

	} while ( count > 0 ) ;
}
