
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */
/* Permission to use, copy, modify and distribute this software for any      */
/* purpose and without fee is hereby granted, provided that this copyright   */
/* notice appear in all copies as well as supporting documentation. All      */
/* work developed as a consequence of the use of this program should duly    */
/* acknowledge such use.                                                     */
/* ------------------------------------------------------------------------- */

/* you don't have to change the following code for a different device
 */

#include <stdio.h>
#define PRINTER_KERNEL
#include "printer.h"

/****************
		*
		*	startup
		*
		**************************************************************/
void printer_startup(
pbu_$unit_t             *unit,           /* PBU number */
pbu_$ddf_ptr_t          *ddf_ptr,
pbu_$csr_page_ptr_t     *csr_ptr,
status_$t               *status)
{
	printer_port = printer_start((void*)*csr_ptr) ;
	printer_unit = *unit ;
	printer_clear();
	status->all = status_$ok ;
}
/****************
		*
		*	cleanup
		*
		**************************************************************/
void printer_cleanup(void){
	printer_end();
}
/****************
		*
		*	clear buffer
		*
		**************************************************************/
void printer_clear(void){
	/* initialize the memory */
	printer_next = 0 ;
	printer_last = 0 ;
	printer_wakeup = 0 ;
	printer_disable = 1 ;
#ifdef PS
	printer_count = 0 ;
	printer_count_jobs = 0;
	printer_last_eof = 0 ;
	printer_no_int = 0 ;
#endif
}
/*===========================================================================*/
/* for debugging : */
/****************
		*
		*	write the actural bounds
		*
		**************************************************************/
void printer_inq(printer_data_t*d){
	d->next = printer_next ;
	d->last = printer_last ;
	d->total= ( printer_last - printer_next ) & (MAX-1) ;
	d->paper_empty = printer_paper_empty() ;
	d->no_int = printer_no_int ;
#ifdef SPE
	d->status = printer_status() ;
#endif
#ifdef PS
	d->count = printer_count ;
	d->last_eof = printer_last_eof ;
	d->count_jobs = printer_count_jobs ;
#endif
}
int printer_toggel(void){
	return printer_no_int ^= 1 ;
}
/****************
                *
                *       start transmission again
                *
                **************************************************************/
static void printer_enable(void){
        status_$t       status ;
        if ( printer_last != printer_next ) {
                /* the buffer is not mepty */
                printer_disable = 0 ;
                /* write one char */
                printer_write_char();
                pbu_$enable_device ( printer_unit , &status ) ;
        }
}
/****************
		*
		*	copy the charaters into the buffer
		*
		**************************************************************/
void printer_put(char*p,int *ll){

	status_$t		status ;
	pbu_$wait_index_t	index ;
	int			count = (*ll) ;
	int			last = printer_last ;

#ifdef SPE
	if ( printer_no_int ) {
		printer_write_n_chars(p,count);
		p += count ;
#ifdef PS
		printer_count += count ;
		if ( p[-1] == (char)4 ) {
			printer_count_jobs ++ ;
			printer_last_eof = printer_count ;
		}
#endif
		return ;
	}
#endif

	while( printer_paper_empty() ) sleep(30);
	do {
		/* Berechnung der freien Plaetze im Puffer.
		 */
		int free = ( printer_next - last - 1 ) & ( MAX - 1 ) ;
		/* free liegt nun im Intervall [0..MAX-1]
		 */
		if ( count <= free ) {
			/* Da die Zwischenergebnisse von po.b nicht 
			 * allgemien gueltig sind, wird hier mit der
			 * Hilfsvariablen d gerechnet.
			 * Nachdem d dann auf das Ende der Zeichen zeigt,
			 * wird d wieder nach po.b geladen.
			 */
#ifdef PS
			printer_count += count ;
#endif
			do {
				printer_buffer[last] = *p ; p++ ;
				/* increment and adjust */
				last ++ ; last &= ( MAX - 1 ) ;
				/* write back */
				printer_last = last ;
			} while ( --count ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
			if ( printer_disable == 1 ) printer_enable();
			return ;
		}

		/*
		 * writing some bytes into the buffer
		 */
		if ( free > 0 ) {
			int n = free ;
			if ( n > count ) n = count ;
			if ( n > LIMIT ) n = LIMIT ;
			count -= n ;
#ifdef PS
			printer_count += n ;
#endif
			do {
				printer_buffer[last] = *p ; p++ ;
				last ++ ; last &= ( MAX - 1 ) ;
				printer_last = last ;
			} while ( --n ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
		}
		/*
		 * wake up the interrupt routine - if needed
		 */
		if ( printer_disable == 1 ) printer_enable();
		/*
		 * writing more bytes into the buffer
		 */
		while ( (free=(printer_next-last-1)&(MAX-1)) > LIMIT ) {
			int n = free ;
			if ( n > count ) n = count ;
			count -= n ;
#ifdef PS
			printer_count += n ;
#endif
			do {
				printer_buffer[last] = *p++ ;
				last ++ ; last &= ( MAX - 1 ) ;
				printer_last = last ;
			} while ( --n ) ;
#ifdef PS
			if ( p[-1] == (char)4 ) {
				printer_count_jobs ++ ;
				printer_last_eof = printer_count ;
			}
#endif
			/*
			 * wake up the interrupt routine - if needed
			 */
			if ( printer_disable == 1 ) printer_enable();
			/*
			 * ready ?
			 */
			if ( count == 0 ) return ;
		}
		/*
		 * wakeup after wakeup bytes
		 */
		if ( count > 0 ) {
			printer_wakeup = count ;
			if ( printer_wakeup > ( MAX >> 1 ) )
				printer_wakeup = ( MAX >> 1 ) ;
			if ( printer_wakeup < ( MAX >> 4 ) )
				printer_wakeup = ( MAX >> 4 ) ;
		}
		/*
		 * wake up the interrupt routine - if needed
		 */
		if ( printer_disable == 1 ) printer_enable();
		/*
		 * wait for ec-advance - if needed
		 */
		if ( count > 0 ) {
			pbu_$wait( printer_unit, 1000, true, &status );
		}

	} while ( count > 0 ) ;
}
