
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */ 
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */
/* Permission to use, copy, modify and distribute this software for any      */
/* purpose and without fee is hereby granted, provided that this copyright   */
/* notice appear in all copies as well as supporting documentation. All      */
/* work developed as a consequence of the use of this program should duly    */
/* acknowledge such use.                                                     */
/* ------------------------------------------------------------------------- */

#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pad.h>
#include <apollo/error.h>

main(argc,argv)int argc; char**argv;{

	status_$t	st; 

	short	i,ii,
		j,jj;
	int	wx = 20 ,
		wy = 20 ,
		dx =  512 +10 ,
		dy =  64 ;

	gpr_$disp_char_t	disp_char;
	gpr_$offset_t		bitmap_size;
	gpr_$bitmap_desc_t	bitmap_id;
	short			len;
	gpr_$rgb_plane_t	hi_plane;  
	char*			bitmap_adresse;
	stream_$id_t		stream_id;
	gpr_$pixel_value_t	draw_value = 7 ;
	pad_$window_desc_t	window;
   
	window.top    = wx + 26 ;
	window.left   = wy +  5 ;
	window.width  = dx - 10 ;
	window.height = dy - 35 ;

	
	pad_$create_window("",0,pad_$transcript,1,window,&stream_id,&st);
	if ( st.all != status_$ok ) {
		puts("create");
		error_$print(st) ;
		exit(1);
	}
	pad_$set_border(stream_id,1,false,&st);
	if ( st.all != status_$ok ) error_$print(st) ;
	pad_$set_auto_close(stream_id,1,true,&st);
	if ( st.all != status_$ok ) error_$print(st) ;
	gpr_$inq_disp_characteristics(gpr_$direct,stream_id,
		sizeof(disp_char),&disp_char,&len,&st);
	if ( st.all != status_$ok ) error_$print(st) ;

	hi_plane = disp_char.n_planes - 1;                      
	bitmap_size.x_size = dx ;
	bitmap_size.y_size = dy ;
	gpr_$init(gpr_$direct,stream_id,bitmap_size,hi_plane,&bitmap_id,&st);
	if ( st.all != status_$ok ) error_$print(st) ;
	gpr_$set_auto_refresh(true,&st);
	if ( st.all != status_$ok ) error_$print(st) ;
	gpr_$set_obscured_opt(gpr_$pop_if_obs,&st);
	if ( st.all != status_$ok ) error_$print(st) ;

#define window_define_color(nr,r,g,b)active_lut[nr]=(r<<16)+(g<<8)+b

	gpr_$acquire_display(&st); 
	if ( st.all != status_$ok ) error_$print(st) ;
	if ( argc >= 6 ) {
		draw_value = atoi(argv[5]) ;
		gpr_$set_draw_value(draw_value,&st);
		gpr_$set_fill_value(draw_value,&st);
	} else if (hi_plane == 7){
		gpr_$set_draw_value(7,&st);
		gpr_$set_fill_value(7,&st);
	}else{
		gpr_$set_draw_value(7,&st);
		gpr_$set_fill_value(7,&st);
	}
	gpr_$release_display(&st);
	if ( st.all != status_$ok ) error_$print(st) ;

	for ( ;; ) {
		short a ;
		short b ;
		short d ;
		po_bounds(&a,&b);
		d = b - a ;
		a >>= 5 ;
		b >>= 5 ;
		gpr_$acquire_display(&st); 
		if ( st.all != status_$ok ) error_$print(st) ;
		gpr_$clear(0,&st);
		if ( st.all != status_$ok ) error_$print(st) ;
		if ( d > 0 ) {
			gpr_$move(a,5,&st);
			gpr_$line(b+2,5,&st);
		} else if ( d < 0 ) {
			gpr_$move(0,5,&st);
			gpr_$line(a,5,&st);
			gpr_$move(b,5,&st);
			gpr_$line(511,5,&st);
		} else {
			gpr_$move(a,5,&st);
			gpr_$line(b+2,5,&st);
		}
		gpr_$release_display(&st);
		if ( st.all != status_$ok ) error_$print(st) ;
	}

}
