
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */ 
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */
/* Permission to use, copy, modify and distribute this software for any      */
/* purpose and without fee is hereby granted, provided that this copyright   */
/* notice appear in all copies as well as supporting documentation. All      */
/* work developed as a consequence of the use of this program should duly    */
/* acknowledge such use.                                                     */
/* ------------------------------------------------------------------------- */

typedef volatile char reg;

typedef struct {
	int next , last , total , paper_empty ;
	char status ;
	int count , last_eof , count_jobs ;
	int no_int ;
} printer_data_t ;

extern void printer_clear(void);
extern void printer_put(char*,int&);
extern void printer_dump(void);
extern reg* printer_start(reg*p);
extern void printer_end(void);
extern unsigned char printer_status(void);
extern void printer_inq(printer_data_t*);
extern unsigned char printer_paper_empty(void);
extern void printer_write_char(void) ;
extern int printer_toggel(void) ;
extern int printer_write_n_chars(char*,int);

#ifdef PRINTER_KERNEL
#nolist
#include <apollo/base.h>
#include <apollo/pbu.h>
#list

/* thefollowing number must be a power of 2 */
#define MAX (1<<15)

/* The following is the limit of free bytes we expect to copy something
 * into the buffer, otherwise we wait a little bit.
 * This Number should be in the range of 128 to (MAX>>4).
 */
#define LIMIT (1<<12)

extern char printer_buffer[MAX] ;
extern int  volatile printer_next ;
extern int  volatile printer_last ;
extern int  printer_wakeup ;
extern int  printer_disable ;
extern reg  *printer_port ;
extern int  printer_no_int ;
extern pbu_$unit_t
	    printer_unit ;

#ifdef PS
extern int printer_count ;
extern int printer_last_eof ;
extern int printer_count_jobs ;
#endif

#ifdef SPE
#define BUSY	(!(printer_port[1] & (char)0x80 ))
#define NBUSY	( (printer_port[1] & (char)0x80 ))
#define ACK	(!(printer_port[1] & (char)0x40 ))
#define PE	( (printer_port[1] & (char)0x20 ))
#define STROBE	( (char) 0x01 )
#define NSTROBE	( (char) 0x00 )
#define E_INT   ( (char) 0x10 )
#endif

#endif
