
/* ------------------------------------------------------------------------- */
/*                             AUTHOR :                                      */
/* ------------------------------------------------------------------------- */
/* J"org Weule                       Mathematisches Institut der             */ 
/*                                   Heinrich-Heine-Universitaet Duesseldorf */
/* email: weule@cs.uni-duesseldorf.de              Abteilung fuer Informatik */
/* ------------------------------------------------------------------------- */

#include <apollo/base.h>
#include <apollo/ios.h>
#include <apollo/io_traits.h>
#include <apollo/trait.h>
#include <apollo/pfm.h>

#include "../ddf/printer.h"

/* ========================================================================== */

                               extern uid_$t 

          /* change the following name to the name of your type:  */

                                lapr_$uid;

/* ========================================================================== */

void pio_$open(
	xoid_$t			*xoid ,
	ios_$open_options_t	*opts,
	void			**result_h,
	status_$t		*st 
){
	*result_h = (void*)0;
	printer_start((void*)0);
	st->all = status_$ok;
}

void pio_$initialize(
	xoid_$t			*xoid ,
	xoid_$t			*copy_xoid ,
	ios_$open_options_t	*opts ,
	void			**result_h ,
	status_$t		*st 
){
    pio_$open( xoid, opts, result_h, st );
}

/* ========================================================================== */

boolean pio_$close(
	void			*&h ,
	status_$t		*st
){
	st->all = 		status_$ok;
	return			false ;
}

ios_$mgr_flag_set pio_$inq_mgr_flags(
	void			**h ,
	status_$t		*st 
){
	st->all =		status_$ok;
	return			ios_$mf_write ; /* Write files */
}

ios_$obj_flag_set pio_$inq_obj_flags(
	void			**h,
	status_$t		*st 
){
	st->all =		status_$ok;
	return			ios_$of_ascii;
}

ios_$conn_flag_set pio_$inq_conn_flags(
	void			**h,
	status_$t		*st 
){
	st->all =		status_$ok;
	return			0 ;
}

void pio_$put(
	void			**h,
	ios_$put_get_opts_t 	*opt,
	void			*buf ,
	long			*buf_len,
	status_$t		*st 
){
	printer_put( buf , *buf_len );
        st->all = status_$ok ;
}

io_oc_$epv pio_open_epv = { pio_$open, pio_$initialize };

io_$epv    pio_io_epv = {
	/* basic ios calls */
	/*export =*/ 		0,
	/*import =*/		0,
	/*pre_fork =*/		0,
	/*post_fork =*/		0,
	/*close =*/		pio_$close,
	/* misc */
	/*get_ec =*/		0,
	/*inq_mgr_flags =*/	pio_$inq_mgr_flags,
	/*inq_obj_flags =*/	pio_$inq_obj_flags,
	/*set_obj_flag =*/	0,
	/*inq_conn_flags =*/	pio_$inq_conn_flags,
	/*set_conn_flag =*/	0,
	/* tranfer calls */
	/*get =*/		0,
	/*locate =*/		0,
	/*put =*/		pio_$put,
	/*inq_rec_remainder =*/	0,
	/* seek */
	/*seek =*/		0,
	/*seek_full_key =*/	0,
	/*seek_short_key =*/	0,
	/*seek_to_bof =*/	0,
	/*seek_to_eof =*/	0,
	/*inq_short_key =*/	0,
	/*inq_full_key =*/	0,
	/*inq_rec_pos =*/	0,
	/*inq_byte_pos =*/	0,
	/*truncate =*/		0,
	/* inquire/set */
	/*inq_cur_rec_len =*/	0,
	/*inq_rec_type =*/	0,
	/*set_rec_type =*/	0,
	/* apollo files */
	/*force_write_file =*/	0,
	/*inq_file_attr =*/	0,
	/*equal =*/		0,
	/* reserved */
	/*export_to =*/		0,
	/*putp =*/		0
};


void ios_$initialize(void){

	status_$t sts ;

	/* declare the IO Open and Create trait */
	trait_$mgr_dcl(
		lapr_$uid,
		&io_oc_$trait,
                trait_$kind_local | trait_$kind_near_remote,
		&pio_open_epv,
		&sts
		);
	if ( sts.all != status_$ok ) pfm_$error_trap( sts );

	/* declare the IO trait */
	trait_$mgr_dcl( lapr_$uid, /* type UID */
		&io_$trait,  /* trait being declared */
		trait_$kind_local | trait_$kind_near_remote , 
		/* implemented locations */
		&pio_io_epv, /* ptr to the trait EPV */
		&sts);
	if ( sts.all != status_$ok ) pfm_$error_trap( sts ); 

}
