/*
 * Control Registers.   IOBASE + $x
 *
 * Control 3A and 3B serve identical functions except that 3A
 * deals with control 1 and 3b deals with Color LUT reg.
 */
#define AP_IOBASE	0x3d0		/* Base address of 4/8 plane board. */
#define AP_STATUS	0x3d0		/* Status register.  Read */
#define AP_WRITE_ENABLE	0x3d0		/* Write Enable Register Write */
#define AP_DEVICE_ID	0x3d1		/* Device ID Register. Read */
#define AP_ROP_1	0x3d2		/* Raster Operation reg. Write Word */
#define AP_DIAG_MEM_REQ 0x3d4		/* Diagnostic Memory Request. Write Word */
#define AP_CONTROL_0	0x3d8		/* Control Register 0.  Read/Write */
#define AP_CONTROL_1	0x3da		/* Control Register 1.  Read/Write */
#define AP_CONTROL_3A	0x3de		/* Control Register 3a.	Read/Write */
#define AP_CONTROL_2	0x3dc		/* Control Register 2. Read/Write */
#define AP_RED_LUP_TBL	0x3d9		/* Red Lookup Table Register. Write */
#define AP_GRN_LUP_TBL	0x3db		/* Green Lookup Table Register. Write */
#define AP_BLU_LUP_TBL	0x3dd		/* Blue Lookup Table Register. Write */
#define AP_AD_CHANNEL	0x3df		/* A/D Channel Register. Write */
#define AP_AD_RESULT	0x3df		/* A/D Result Register.  Read  */
/*
 * Primary Shared Memory address is 0xA00000 - 0xA1FFFF.
 * The card can be configured to go to the secondary address but
 * since BIOS lives there, we gots no choice in da matter. 
 */
#define AP_MEM_ADDR_1   0xA0000
#define AP_MEM_ADDR_2   0xB0000
#define AP_ZBUFF_ADDR	0xB9000
/*
 * Character set defs.
 */
#define CHARSET_HEIGHT 16
#define R_CHARSET_HEIGHT 8
#define CHARSET_WIDTH 8
#define R_CHARSET_WIDTH 8
#define CHARSET_X 0
#define CHARSET_Y 900

/* CREG 0 */
#define VECTOR_MODE 0x40 /* 010x.xxxx */
#define DBLT_MODE   0x80 /* 100x.xxxx */
#define NORMAL_MODE 0xE0 /* 111x.xxxx */
#define SHIFT_BITS  0x1F /* xxx1.1111 */
	/* other bits are Shift value */

/* CREG 1 */
#define AD_BLT      0x80 /* 1xxx.xxxx */
#define AD_HIBIT    0x40 /* xIxx.xxxx */

#define PIX_BLT     0x00 /* 0xxx.xxxx */

#define ROP_EN		0x10 /* xxx1.xxxx */
#define DST_EQ_SRC	0x00 /* xxx0.xxxx */

#define nRESET_SYNC	0x08 /* xxxx.1xxx */
#define SYNC_ENAB	0x02 /* xxxx.xx1x */

#define BLANK_DISP	0x00 /* xxxx.xxx0 */
#define ENAB_DISP	0x01 /* xxxx.xxx1 */

#define NORM_CREG1	(nRESET_SYNC | SYNC_ENAB | ENAB_DISP) /* no reset sync */

/* CREG 2 */
#	define S_PLANE_0   0x00 /* xx00.xxxx */
#	define S_PLANE_1   0x10 /* xx01.xxxx */
#	define S_PLANE_2   0x20 /* xx10.xxxx */
#	define S_PLANE_3   0x30 /* xx11.xxxx */
#	define ALL_PLANES 0xf
#	define D_PLANE_0 0x1
#	define D_PLANE_1 0x2
#	define D_PLANE_2 0x4
#	define D_PLANE_3 0x8
/*
 * Following 4 defines are common to both 4 and 8 plane. 
 */
#define D_PLANES(plane_mask)  ((~plane_mask) & ALL_PLANES) /* D planes must be ANDed to work so... lets OR then convert  */
#define S_DATA_1s   0x00 /* 00xx.xxxx */
#define S_DATA_PIX  0x40 /* 01xx.xxxx */
#define S_DATA_PLN  0xC0 /* 11xx.xxxx */


/* CREG 3A/CREG 3B */
#	define RESET_CREG 0x80 /* 1000.0000 */

/* ROP REG  -  all one nibble */
/*	********* NOTE : this is used r0,r1,r2,r3 *********** */
#define ROP(r2,r3,r0,r1) ( (U_SHORT)((r0)|((r1)<<4)|((r2)<<8)|((r3)<<12)) )
#define DEST_ZERO		0x0
#define SRC_AND_DEST	0x1
#define SRC_AND_nDEST	0x2
#define SRC				0x3
#define nSRC_AND_DEST	0x4
#define DEST			0x5
#define SRC_XOR_DEST	0x6
#define SRC_OR_DEST		0x7
#define SRC_NOR_DEST	0x8
#define SRC_XNOR_DEST	0x9
#define nDEST			0xA
#define SRC_OR_nDEST	0xB
#define nSRC			0xC
#define nSRC_OR_DEST	0xD
#define SRC_NAND_DEST	0xE
#define DEST_ONE		0xF

/* DISPLAY INFORMATION */
#define MAX_X 1024
#define MAX_Y 800
#define MAX_COLS (MAX_X/CHARSET_WIDTH)
#define MAX_ROWS (MAX_Y/R_CHARSET_HEIGHT)
#define WORD_WIDTH 64
/*
 * The cursor starts just below the character set in ZBUFF.
 */
#define CURSOR_START	(CHARSET_Y+(R_CHARSET_HEIGHT*3))
/* 
 * a few typedefs 
 */
typedef unsigned char U_CHAR;
typedef unsigned long U_LONG;
typedef unsigned short U_SHORT;
typedef unsigned int U_INT;
