#if __GNUC__ >= 2
__main() {}
#endif

/*
 * Define the type of card here 
 */
#define APOLLO_4

/* Define the resolution for mono cards - HIRES means to use the 
 * 1280x1024 card not defined means the 1024x800 card 
 */
/*#define HIRES */

/* Define to mmap the frame buffer, only really useful for linux, 
 * and really for user-mode debugging.. 
 */
/*#define GRAPH_MMAP */

#if defined(APOLLO_1)
#include "a1.h"
#endif
#if defined(APOLLO_4)
#include "a4.h"
#endif
#if defined(APOLLO_8)
#include "a8.h"
#endif

#ifndef __linux__
#include "2681.h"
#include "io.h"
#endif

#include "charset.h"
/*
#include <endian.h>
#define __BYTE_ORDER __LITTLE_ENDIAN
#if __BYTE_ORDER == __BIG_ENDIAN
#include <netinet/in.h>
#define	SWAP(w)		htons(w)
#endif
#if __BYTE_ORDER == __LITTLE_ENDIAN
*/
#define SWAP(w)		(w)
/*
#endif
*/

unsigned short row, col; /* Cursor row and column */

#if defined(GRAPH_MMAP) & defined(__linux__)
#include <unistd.h>
#include <sys/kd.h>
#include <linux/mm.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <termios.h>

cbreak()
{
	struct termios _tios;
	
	tcgetattr(0,&_tios);
	_tios.c_lflag&=~ICANON;
	tcsetattr(0,TCSANOW,&_tios);
}

static U_INT	tty0_fd;   /* Current console file descriptor */
static U_INT	mem_fd;    /* Memory map file descriptor */
static U_SHORT * graph_mem; /* dummy buffer for mmapping graphics memory */

/*
 * Get ioperms, and mmap grapics memory.  This will only work on linux
 * systems and even then, it is used only for user-space development.
 */

void
get_perms()
{

	if (ioperm(AP_IOBASE,0x10,1)) {
		printf("Can't get I/O perms\n");
		exit(-1);
	}
	if ((tty0_fd = open("/dev/tty0", O_RDONLY) ) <0) {
		printf("Can't open /dev/tty0\n");
		exit(-1);
	}
	
	/* disable text output to console */
	ioctl(tty0_fd, KDSETMODE, KD_GRAPHICS);
	
	if ((mem_fd = open("/dev/mem", O_RDWR) ) < 0) {
		printf("Can't open /dev/mem\n");
		end(-1);
	}
	
	/* mmap graphics memory */
	if ((graph_mem = (U_SHORT *)malloc(AP_MEM_SIZE + (PAGE_SIZE-1))) == NULL) {
		printf("Memory allocation error\n");
		exit(-1);
	}
	if ((unsigned long)graph_mem % PAGE_SIZE)
		graph_mem += PAGE_SIZE - ((unsigned long)graph_mem % PAGE_SIZE);
	graph_mem = (U_SHORT *)mmap(
		(caddr_t)graph_mem,
		AP_MEM_SIZE,
		PROT_READ|PROT_WRITE,
		MAP_SHARED|MAP_FIXED,
		mem_fd,
		AP_MEM_ADDR_1
	);
	if ((long)graph_mem < 0) {
		printf("Mmap error\n");
		exit(-1);
	}
}
#endif /* __linux__ */

void 
init_ap()
{
	volatile U_SHORT i;
	volatile U_CHAR l_addr;
	volatile int c;

	outb(AP_CONTROL_3A, RESET_CREG);
#ifdef APOLLO_8
	outb(AP_CONTROL_3B, RESET_CREG);
#endif
	outb(AP_CONTROL_1, (AD_BLT | DST_EQ_SRC | NORM_CREG1) );
	outb(AP_CONTROL_0, NORMAL_MODE);
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_PLN | S_PLANE_0 ) );
	outb(AP_CONTROL_3A, 0x0);
	outb(AP_CONTROL_3B, 0x0);

/*
 * Once bit 0 in Status reg is clear, the controller loads
 * the FIFO data into the lookup table during vertical
 * retrace period.  (from Apollo #7861-A01)
 */
	while(1) {
		c=inb(AP_STATUS);
		if(!(c&1))
			break;
	}
	outb(AP_LUT_CONTROL, 0xe8);        /* Reset FIFO */
	outb(AP_LUT_CONTROL, 0xf8);	   /* Pulse  */
	outb(AP_LUT_CONTROL, 0xd8);	   /* Select FIFO */
	for(i=0;i<255*3;i++) {		   /* Load colors into FIFO */ 
#include "a8_colors.h"
		outb(AP_LUT_DATA, RGBvalues[i]);
	}
	outb(AP_LUT_CONTROL, 0xb8);    /* Select color palette chip */
	outb(AP_LUT_DATA, 0x0);        /* Set starting lookup table index */
	outb(AP_LUT_CONTROL, 0xf9);    /* Prime color palette chip */
	outb(AP_LUT_CONTROL, 0xf1);    /* Set LUT_OK; FIFO is full */
	outb(AP_LUT_CONTROL, 0xf9);    /* Pulse */

#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_PLN | S_PLANE_0 | D_PLANES(ALL_PLANES)) );
/*
 * Wait for V_Flag bit to be cleared in status register
 * so we know when we have 100uS to load the lookup tables.
 */
	while(1) {
		c=inb(AP_STATUS);
		if(!(c&1))
			break;  /* V_Flag is set. */
	}
/*
 * V_Flag should be set now.  We load the color lookup tables.
 */
	for(i=0;i<16;i++) {
#include "a4_colors.h"
		l_addr = (i << 4);
		outb(AP_RED_LUP_TBL, l_addr + (RGBvalues[(i*3)+0]>>4));
		outb(AP_GRN_LUP_TBL, l_addr + (RGBvalues[(i*3)+1]>>4));
		outb(AP_BLU_LUP_TBL, l_addr + (RGBvalues[(i*3)+2]>>4));
	}
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_PLN);
#define	BLACK 0
#define WHITE 0xffff
#endif

}

/*
 * Set the word at x,y to color_entry c.
 *  Pass plane_mask from 0-f.
 */
void
ap_put_word(x, y, c)
	U_SHORT x, y;
	U_SHORT c;
{
	volatile U_SHORT *imem;
	U_LONG offset;

#ifdef GRAPH_MMAP
	imem = (U_SHORT *)graph_mem;
#else
	imem = (U_SHORT *)AP_MEM_ADDR_1;
#endif
		
		/* skip x values which are off the word boundary */
	offset = ( (x/8) + (y*WORD_WIDTH) );

	*(imem+offset) = SWAP(c);
}

#ifdef APOLLO_8
U_LONG
make_rop2(fg,bg)
	U_SHORT fg,bg;
{
	unsigned int i;
	U_LONG rtn=0;
	
	for (i=1; i<256; i<<=1) {
		rtn<<=4;
		if (fg & i)
			if (bg & i)
				rtn+=DEST_ONE;
			else
				rtn+=SRC;
		else
			if (bg & i)
				rtn+=nSRC;
			else
				rtn+=DEST_ZERO;
	}

	return(rtn);
}
#endif
#ifndef APOLLO_8
U_SHORT
make_rop2(fg,bg)
	U_SHORT fg,bg;
{
	int i;
	U_SHORT rtn=0;
	
	for (i=1; i<16; i<<=1) {
		rtn<<=4;
		if (fg & i)
			if (bg & i)
				rtn+=DEST_ONE;
			else
				rtn+=SRC;
		else
			if (bg & i)
				rtn+=nSRC;
			else
				rtn+=DEST_ZERO;
	}
	return(rtn);
}
#endif
#ifdef APOLLO_1x
/*
 * This routine is severly hacked around, but once upon a time, it
 * contained my estimation of the ROPs for monochrome.  I never did
 * get it going properly (I suspect I need to duplicate the ROP 
 * four times over the return value, but havent checked).  The 4-plane
 * version seems to work fine for monochrome though
 */
U_SHORT
make_rop2(fg,bg)
	U_SHORT fg,bg;
{
	if (fg = BLACK)
		if (bg != BLACK)
			return(DEST_ONE);
		else
			return(SRC);
	else
		if (bg != BLACK)
			return(nSRC);
		else
			return(DEST_ZERO);
}
#endif

void
ap_putc(x, y, c, fg, bg)
	U_SHORT x, y;
	U_CHAR c;
	U_SHORT fg, bg;
{
	U_SHORT i;
	U_SHORT sy, sx;
	U_SHORT dy, dx;
	volatile U_SHORT *imem;
	volatile U_LONG Dest;
	U_LONG Src;
	U_INT hibit = 0;
#ifdef APOLLO_8
	union {
	    U_LONG l;
	    struct {
		U_SHORT hi;
		U_SHORT lo;
	    } s;
	} color_rop;
#else
	U_SHORT color_rop;
#endif

#ifdef GRAPH_MMAP
	imem=(U_SHORT *)graph_mem;
#else
	imem=(U_SHORT *)AP_MEM_ADDR_1;
#endif


	outb(AP_CONTROL_0, DBLT_MODE);
	outb(AP_CONTROL_1, (AD_BLT | ROP_EN | NORM_CREG1) );
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_PLN | S_PLANE_0 ) );
	color_rop.l=make_rop2(fg,bg);
	outw(AP_ROP_1, SWAP(color_rop.s.lo));
	outw(AP_ROP_2, SWAP(color_rop.s.hi));
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_PLN | S_PLANE_0 | D_PLANES(ALL_PLANES)) );
	color_rop=make_rop2(fg,bg);
	outw(AP_ROP_1, SWAP(color_rop));
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_PLN);
	color_rop=make_rop2(fg,bg);
	outw(AP_ROP_1, SWAP(color_rop));
#endif

	/* not on word boundary */
	if(x&1)	
		outw(AP_WRITE_ENABLE, SWAP(0xff00));
	else
		outw(AP_WRITE_ENABLE, SWAP(0x00ff));
	
	sy=CHARSET_Y;
	sx=c*CHARSET_WIDTH*2;
	if (sx>=MAX_X) {
		sx=(sx%(MAX_X));
		sy+=CHARSET_HEIGHT;
	}
	dx=x*CHARSET_WIDTH;
	dy=y*CHARSET_HEIGHT;
	hibit = 0;
	Dest = dx/16 + dy*WORD_WIDTH;
	Src = sx/16 + sy*WORD_WIDTH;
	for (i=0;i<CHARSET_HEIGHT;i++) {
		if ((Dest > 0xffff) & !hibit) {
			outb(AP_CONTROL_1, (AD_HIBIT | AD_BLT | ROP_EN | NORM_CREG1) );
			hibit = 1;
		}
		*(imem + Src) = SWAP(Dest);
		Dest+=WORD_WIDTH;
		Src+=WORD_WIDTH;
	}
	outb(AP_CONTROL_1, (AD_BLT | ROP_EN | NORM_CREG1) );
}

/*
 * Basically the same as ap_putc except instead of supplying a 
 * character, we supply a raster_op so we can do things like
 * a cursor sometimes does.
 */
void
ap_put_cursor(x, y, color_rop)
	U_SHORT x, y;
#ifdef APOLLO_8
	U_LONG color_rop;
#else
	U_SHORT color_rop;
#endif
{
	short i;
	U_SHORT sy, sx;
	U_SHORT dy, dx;
	volatile U_SHORT *imem;
	volatile U_LONG Dest;
	volatile U_LONG Src;
	U_INT hibit = 0;

#ifdef GRAPH_MMAP
	imem=(U_SHORT *)graph_mem;
#else
	imem=(U_SHORT *)AP_MEM_ADDR_1;
#endif

/*
 * The Raster op is Src XOR dest
 */
	outb(AP_CONTROL_0, DBLT_MODE);
	outb(AP_CONTROL_1, (AD_BLT | ROP_EN | NORM_CREG1) );
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_PLN | S_PLANE_0 ) );
	outw(AP_ROP_1, 0x6666);
	outw(AP_ROP_2, 0x6666);
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_PLN | S_PLANE_0 | D_PLANES(ALL_PLANES)) );
	outw(AP_ROP_1, 0x6666);
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_PLN);
	outw(AP_ROP_1, 0x6666);
#endif

	if (x&1) /* not on word boundary */
		outw(AP_WRITE_ENABLE, SWAP(0xff00));
	else
		outw(AP_WRITE_ENABLE, SWAP(0x00ff));
	
	sy=CHARSET_Y;
	sx=128*CHARSET_WIDTH*2;
	if (sx>=MAX_X) {
		sx=(sx%(MAX_X));
		sy+=CHARSET_HEIGHT;
	}
	dx=x*CHARSET_WIDTH;
	dy=y*CHARSET_HEIGHT;
	hibit = 0;
	Dest = dx/16 + dy*WORD_WIDTH;
	Src = sx/16 + sy*WORD_WIDTH;
	for (i=0;i<CHARSET_HEIGHT;i++) {
		if ((Dest > 0xffff) & !hibit) {
			outb(AP_CONTROL_1, (AD_HIBIT | AD_BLT | ROP_EN | NORM_CREG1) );
			hibit = 1;
		}
		*(imem+ Src) = SWAP(Dest);
		Dest+=WORD_WIDTH;
		Src+=WORD_WIDTH;
	}
}

/*
 * The character set is blit'd into the ZBUFFER
 * to facilitate quick blit'ing onto the screen later.  So we don't
 * have to worry about shift later, each character is duplicated twice
 * so as to take up a whole word (ie: aa bb cc dd ee ff ).  Later, when
 * we need to dump a character onto the screen, if the destination
 * is a highorder byte, we take the high-order character and vice
 * versa.  After the character set is uploaded, (which conveniently
 * takes two rows the full width of the screen) we blit two cursors
 * into position as well (at x=(0, 1); y=CHARSET_Y+(3*R_CHARSET_HEIGHT) )
 */
void
upload_charset() {
	U_SHORT x,y,c, i;
	U_SHORT *pcursor;

	x=CHARSET_X;
	y=CHARSET_Y;

	outb(AP_CONTROL_0, NORMAL_MODE);
	outb(AP_CONTROL_1, (AD_BLT | DST_EQ_SRC | NORM_CREG1) );

#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_PLN | S_PLANE_3 ) );
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_PLN | S_PLANE_3 | D_PLANES(ALL_PLANES)) ); 
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_PLN); 
#endif
	outw(AP_WRITE_ENABLE, SWAP((U_SHORT) 0x0000));
	pcursor = charset;
	for(c=0;c<128;c++) {
		for(i=0;i<CHARSET_HEIGHT;i++) {
			ap_put_word(x, y+i, (*pcursor | (*pcursor<<8)));
			pcursor++;
		}
		x += CHARSET_WIDTH; /* we skip to word boundary */
		if (x >= MAX_X/2) {
			x=CHARSET_X;
			y+=CHARSET_HEIGHT;
		}
	}

	/* We blit a cursor after the charset.  Currently, a big
	 * white blob.
	 */
	for(i=0 ; i<CHARSET_HEIGHT ; i++) {
			ap_put_word(x,y+i, 0xffff);
	}
	
	/*
	 * Check to see if how the screen actually works is the same
	 * as how I think it works .... Finally found the correct
	 * byte swapping for everything by using this....
	 */
	/*
	for(i=0; i<1000; i++) {
		ap_put_word(i/2,i,0x8000>>(i%16));
	}
	*/
}

#ifdef APOLLO_8
U_LONG
make_rop(color)
	U_SHORT color;
{
	unsigned int i;
	U_LONG rtn=0;
	
	for (i=1; i<256; i<<=1) {
		rtn<<=4;
		if (color & i)
			rtn+=DEST_ONE;
		else
			rtn+=DEST_ZERO;
	}
	return(rtn);
}
#endif
#ifndef APOLLO_8
U_SHORT
make_rop(color)
	U_SHORT color;
{
	int i;
	U_SHORT rtn=0;
	
	for (i=1; i<16; i<<=1) {
		rtn<<=4;
		if (color & i)
			rtn+=DEST_ONE;
		else
			rtn+=DEST_ZERO;
	}
	return(rtn);
}
#endif
#ifdef APOLLO_1x
/*
 * This routine has the same rationale as the make_rop2 routine
 * for monochrome.
 */
U_SHORT
make_rop(color)
	U_SHORT color;
{
	
	if (color != BLACK)
		return(DEST_ONE);
	else
		return(DEST_ZERO);
}
#endif

void
ap_cls(color)
	U_SHORT color;
{
#ifdef APOLLO_8
	union {
	    U_LONG l;
	    struct {
		U_SHORT hi;
		U_SHORT lo;
	    } s;
	} color_rop;
#else
	U_SHORT color_rop;
#endif
	U_LONG  *imem;
	U_LONG y;

#ifdef GRAPH_MMAP
	imem=(U_LONG *)graph_mem;
#else
	imem=(U_LONG *)AP_MEM_ADDR_1;
#endif

	outw(AP_WRITE_ENABLE, 0x0);
	outb(AP_CONTROL_0, NORMAL_MODE);
	outb(AP_CONTROL_1, (AD_BLT | ROP_EN | NORM_CREG1) );
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_1s | S_PLANE_3 ) );
	color_rop.l=make_rop(color);
	outw(AP_ROP_1, SWAP(color_rop.s.lo));
	outw(AP_ROP_2, SWAP(color_rop.s.hi));
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_1s | S_PLANE_3 | D_PLANES(ALL_PLANES)) ); 
	color_rop=make_rop(color);
	outw(AP_ROP_1, SWAP(color_rop));
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_1s); 
	color_rop=make_rop(color);
	outw(AP_ROP_1, SWAP(color_rop));
#endif

	y=*imem; /* Dummyious load pour obtainer all ones in source latches */

	outb(AP_CONTROL_0, VECTOR_MODE);


	for(y=0;y<MAX_Y;y++) {
		U_LONG w;
		U_LONG *ty;

/* 8*4 == 8-bits per byte  times 4-bytes per U_LONG */

		ty=y*WORD_WIDTH/2+imem;
		for (w=0;w<(MAX_X/(8*4));w++) {
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w++) + ty)=((U_SHORT) 0);
			*( (w) + ty)=((U_SHORT) 0);
		}
	}
}

/*
 * I dare you to make this execute faster.
 *
 * Actually, I just slowed it down twice :-)
 * - Hi-bit blitting,
 * - non-scroll of righthand Z-buff
 * (It is actually fractionally faster, but only
 * for 1280x1024 cards)
 *				HC.
 */
void ap_scroll_up(NumPix)
U_SHORT NumPix;
{
	U_LONG src, dst;
	U_SHORT *imem;
	U_INT hibit;
	U_LONG y;
	U_LONG dy;

#ifdef GRAPH_MMAP
	imem=(U_SHORT *)graph_mem;
#else
	imem=(U_SHORT *)AP_MEM_ADDR_1;
#endif

	outb(AP_CONTROL_0, DBLT_MODE);
	outb(AP_CONTROL_1, (AD_BLT | DST_EQ_SRC | NORM_CREG1) );
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_PLN | S_PLANE_0 ) );
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_PLN | S_PLANE_0 | D_PLANES(ALL_PLANES)) );
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_PLN);
#endif

	outw(AP_WRITE_ENABLE, 0);
	hibit = 0;
	for (dy=0,y=NumPix*WORD_WIDTH;y<(MAX_Y*WORD_WIDTH);) {
		if ((dy > 0xffff) & !hibit) {
			outb(AP_CONTROL_1, (AD_HIBIT | AD_BLT | DST_EQ_SRC | NORM_CREG1) );
			hibit = 1;
		}

		for (src=y,dst=dy; (src-y)<(MAX_X/16);) {
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
			*((U_SHORT *)(imem+src)) = SWAP(dst);
			dst++; src++;
		}
		y+=WORD_WIDTH;
		dy+=WORD_WIDTH;
	}
#ifdef APOLLO_8
	outb(AP_CONTROL_2A, (D_PLANES(ALL_PLANES)) );
	outb(AP_CONTROL_2B, (S_DATA_1s | S_PLANE_3 ) );
	outw(AP_ROP_1, 0);
	outw(AP_ROP_2, 0);
#endif
#ifdef APOLLO_4
	outb(AP_CONTROL_2, (S_DATA_1s | S_PLANE_3 | D_PLANES(ALL_PLANES)) ); 
	outw(AP_ROP_1, 0);
#endif
#ifdef APOLLO_1
	outb(AP_CONTROL_2, S_DATA_1s); 
	outw(AP_ROP_1, 0);
#endif

/*	y=*imem; /* Dummyious load pour obtainer all ones in source latches */

	outb(AP_CONTROL_0, VECTOR_MODE);
	
	for (y=0;y<NumPix;y++) {

		for (dst=dy;dst-dy<(MAX_X/16);dst++) {
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
			dst++;
			*( (U_SHORT *) (dst + imem))=((U_SHORT) 0);
		}
		dy+=WORD_WIDTH;
	}
		
}

void
ap_add_char(c)
	int c;
{

#ifdef APOLLO_8
	union {
	    U_LONG l;
	    struct {
		U_SHORT hi;
		U_SHORT lo;
	    } s;
	} color_rop;
#else
	U_SHORT color_rop;
#endif
#ifdef APOLLO_8
	color_rop.l=make_rop2(BLACK, CORAL);
#endif
#ifdef APOLLO_4
	color_rop=make_rop2(BLACK, CORAL);
#endif
#ifdef APOLLO_1
	color_rop=make_rop2(BLACK, WHITE);
#endif
#ifdef APOLLO_8
	ap_put_cursor(col, row, color_rop.l);
#else
	ap_put_cursor(col, row, color_rop);
#endif
	switch(c) {
		case '\r': /* CR */
			col=0;
			break;
		case '\n': /* LF */
			col=0;
			row++;
			if (row >= MAX_ROWS) {
				ap_scroll_up(CHARSET_HEIGHT);
				row=MAX_ROWS-1;
			}
			break;
		case '\t':
			col+=(8-(col%8));
			if (col>=MAX_COLS) {
				col=0;
				row++;
				if (row >= MAX_ROWS) {
					ap_scroll_up(CHARSET_HEIGHT);
					row=MAX_ROWS-1;
				}
			}
			break;
		case 12:
			ap_cls(BLACK);
			col=0;row=0;
			break;
		case 8:
			if(col!=0)
				col--;
			ap_putc(col, row, (U_CHAR) 0x20, WHITE, BLACK);
			col--;
			break;
		default:
			ap_putc(col,row,(U_CHAR)c,WHITE,BLACK);
			col++;
			if (col>=MAX_COLS) {
				col=0;
				row++;
				if (row >= MAX_ROWS) {
					ap_scroll_up(CHARSET_HEIGHT);
					row=MAX_ROWS-1;
				}
			}
			break;
	}
#ifdef APOLLO_8
	ap_put_cursor(col, row, color_rop.l);
#else
	ap_put_cursor(col, row, color_rop);
#endif

}

void
main()
{
	int c;

#ifdef GRAPH_MMAP
	get_perms();
#endif
	init_ap();
#ifndef __linux__
	init_2681(0, BD1200, 'E', BPC8); 
#endif

	ap_cls(WHITE);
	ap_cls(BLACK);

	upload_charset();

	row=0; col=0;
#ifndef __linux__
	while ((c=getchar_2681())!= 0x04) {
#else
	cbreak();
	c=' ';
	while (c!=0x04) {
		read(0,&c,1);
#endif
/*		xprintf(MAX_COLS-5,MAX_ROWS-1, "%d ", col);
		xprintf(MAX_COLS-2,MAX_ROWS-1, "%d", row);
		xprintf(MAX_COLS-10, MAX_ROWS-1, "%x", c); */
		putchar(c);
		ap_add_char(c);
	}
	ap_cls(WHITE);
	ap_cls(BLACK);
}

