/*
 * Routines to get a list of disks, and transfer counts on those disks.
 * Written by Jim Rees, U of Michigan, March 2003
 */

#include <sys/types.h>
#include <sys/queue.h>
#include <sys/dkstat.h>
#include <sys/disk.h>

#include <unistd.h>
#include <stdio.h>
#include <nlist.h>
#include <string.h>

#include "kread.h"
#include "dnl.h"

/*
 * For now, just read the first disk.
 * This will be right on most machines.
 */

int
getdkstats()
{
    struct disk disk;
    u_long key;
    struct disklist_head dkhead;

    kread(kmem, nl[N_DISKLIST].n_value, (char *) &dkhead, sizeof dkhead);
    key = (u_long) dkhead.tqh_first;
    kread(kmem, key, &disk, sizeof disk);
    return disk.dk_xfer;
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
