/*
 * Routines to get a list of interfaces, and packet counts on those interfaces.
 * Written by Jim Rees, U of Michigan, March 1995
 */

#include <sys/types.h>
#include <sys/queue.h>
#include <sys/socket.h>
#include <net/if.h>

#include <unistd.h>
#include <stdio.h>
#include <nlist.h>
#include <string.h>

#include "kread.h"
#include "dnl.h"

#ifdef __OpenBSD__
#define if_next if_list.tqe_next
#define if_name if_xname
#endif

#define MAXIF 20

#ifdef TEST
main()
{
    struct ifst *iflist, *ip;
    int ntx, nrx;

    getiflist(&iflist);
    for (ip = iflist; ip->addr; ip++) {
	getifstats(ip->addr, &ntx, &nrx);
	printf("%s %d %d\n", ip->name, ntx, nrx);
    }
    exit(0);
}
#endif

int
getiflist(struct ifst **iflistp)
{
    static struct ifst iflist[MAXIF];
    int nif;
    u_long key;
#ifdef __OpenBSD__
    struct ifnet ifnet;
    struct ifnet_head ifhead;
#else
    struct in_ifaddr ifaddr;
#endif

    kread(kmem, nl[N_IFNET].n_value, &ifhead, sizeof ifhead);
    key = (u_long) ifhead.tqh_first;

    for (nif = 0; key; nif++, key = (u_long) ifnet.if_next) {
	kread(kmem, key, &ifnet, sizeof ifnet);
	iflist[nif].name = strdup(ifnet.if_name);
	iflist[nif].addr = key;
    }
    iflist[nif].addr = NULL;
    *iflistp = iflist;
    return 0;
}

void
getifstats(u_long addr, int *ntx, int *nrx)
{
#ifdef __OpenBSD__
    struct ifnet ifnet;
#else
    struct in_ifaddr ifaddr;
#endif

    kread(kmem, addr, &ifnet, sizeof ifnet);
    *ntx = ifnet.if_opackets;
    *nrx = ifnet.if_ipackets;
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
