#include <sys/types.h>

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <nlist.h>

#include "kread.h"

struct nlist nl[] = {
#ifdef __OpenBSD__
	{ "_ifnet" },
#else
	{ "_ifaddr" },
#endif
	{ "_disklist" },	/* TAILQ of disks */
	{ NULL },
};

char	*system = "/bsd";
char	*kmemf = "/dev/kmem";
int	kmem = -1;

int
kopen()
{
    int fd;

    if (nlist(system, nl) < 0 || nl[0].n_type == 0) {
	fprintf(stderr, "%s: no namelist\n", system);
	return -1;
    }
    fd = open(kmemf, 0);
    if (fd < 0)
	perror(kmemf);
    return fd;
}

void
kread(int kmem, u_long key, void *buf, int n)
{
    lseek(kmem, key, 0);
    read(kmem, buf, n);
}
