/*
 * Drawing widget, with callbacks for buttons, keys, motion, etc.
 * Jim Rees, University of Michigan, May, 1993
 */

#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "DrawP.h"

static void expose(), resize(), jackson(), destroy();
static void Initialize();
static Boolean SetValues();

static char defaultTranslations[] = "\
    <KeyDown>:		keydown() \n\
    <KeyUp>:		keyup() \n\
    <ButtonPress>:	buttonpress() \n\
    <ButtonRelease>:	buttonrelease() \n\
    <MotionNotify>:	motion() \n\
";

static XtActionsRec actionsList[] = {
    { "keydown",	(XtActionProc) jackson	},
    { "keyup",		(XtActionProc) jackson	},
    { "buttonpress",	(XtActionProc) jackson	},
    { "buttonrelease",	(XtActionProc) jackson	},
    { "motion",		(XtActionProc) jackson	},
};

static XtResource resources[] = {
    {XtNexpose, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.expose), XtRPointer, NULL},
    {XtNresize, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.resize), XtRPointer, NULL},
    {XtNcallback, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.jackson), XtRPointer, NULL},
};

DrawClassRec drawClassRec = {
    {
    /* superclass	  	*/	(WidgetClass) &simpleClassRec,
    /* class_name	  	*/	"Draw",
    /* widget_size	  	*/	sizeof(DrawRec),
    /* class_initialize   	*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	actionsList,
    /* num_actions	  	*/	XtNumber(actionsList),
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	FALSE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	(XtWidgetProc) destroy,
    /* resize		  	*/	(XtWidgetProc) resize,
    /* expose		  	*/	(XtExposeProc) expose,
    /* set_values	  	*/	(XtSetValuesFunc) SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	defaultTranslations,
    /* query_geometry		*/	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  }
};

WidgetClass drawWidgetClass = (WidgetClass) &drawClassRec;

static void Initialize(request, new)
Widget request, new;
{
    if (new->core.width == 0)
	new->core.width = 100;
    if (new->core.height == 0)
	new->core.height = 100;
    (*XtClass(new)->core_class.resize) (new);
}

static void
expose(w)
Widget w;
{
    XtCallCallbacks (w, XtNexpose, NULL);
}

static void
resize(w)
Widget w;
{
    XtCallCallbacks (w, XtNresize, NULL);
}

static void
jackson(w, ev, parms, nparms)
Widget w;
XEvent *ev;
String *parms;
Cardinal *nparms;
{
    XtCallCallbacks (w, XtNcallback, ev);
}

static Boolean
SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
    return False;
}

static void
destroy(w)
Widget w;
{
    XtRemoveAllCallbacks (w, XtNexpose);
    XtRemoveAllCallbacks (w, XtNresize);
    XtRemoveAllCallbacks (w, XtNcallback);
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
