#
# Master.cshrc file - run for every C shell started.
#
# Version: 1995/05/23.
#
# Author: Mike Peterson, Department of Chemistry, University of Toronto.
#         <system@alchemy.chem.utoronto.ca>
#
#
# Set default path.
#
set path = (/usr/local/binspecial /usr/ucb /bin /usr/bin /usr/bin/X11 \
 /usr/local/bin /usr/apollo/bin /etc /usr/etc)
set host = `hostname`
#
# Add the personal bin directories ~/bin (for scripts) and ~/bin/apollo
# (for executables)for non-root users.
#
if ("$HOME" != "/") then
   set path = ($path $HOME/bin $HOME/bin/apollo)
   set homepath = $HOME
else
   set homepath =
endif
#
# Put the current directory last.
#
set path = ($path .)
#
# Set default directory search path.
#
set cdpath = (. .. $HOME)
#
# Allow convenient directory change.
# From Markus Gyger, Interkantonales Technikum, Switzerland (mgyger@itr.ch).
#
alias .. 'cd ..'
#
# Prompt generator.
#
if ($?prompt) then
   alias prompt 'set noglob;\\
   set prompt = `dirs`;\\
   set prompt = "${host}:${prompt[1]}> ";\\
   unset noglob'
   alias popd 'popd \!*; prompt'
   alias pushd 'pushd \!*; prompt'
   alias cd 'cd \!*; prompt'
   prompt		# make it appear as the first prompt
endif
#
# Set the default floating point option $FLOAT based on the node type
# and node name.
#
if ("$NODETYPE" == "DN10000" || "$NODETYPE" == "DSP10000") then
   setenv FLOAT '-A cpu,a88k'
else if ($host == todah) then
   setenv FLOAT '-A cpu,fpa1 -W0,-frnd'
else
   setenv FLOAT '-A cpu,3000 -W0,-frnd'
endif
#
# Set the default printer name.
#
setenv PRINTER 'imagen'
#
# Set the default X Windows server name - set to the name of the host
# the user logged in from, unless it was the terminal server (ventus).
# Also strip off the local domain name (.chem.utoronto.ca) if possible.
# If $DISPLAY is already set, leave it alone.
#
if ( ! $?DISPLAY ) then
   setenv DISPLAY "${host}:0"
   set displayhost=`who am i | sed -e 's/.*(//' -e 's/).*$//' -e 's/\.chem\.utoronto\.ca$//'`
   if ("$#displayhost" == "1") then
      if ("$displayhost" != "ventus") then
         setenv DISPLAY $displayhost\:0
      endif
   endif
   unset displayhost
endif
#
# man paging program default (user-selectable).
#
if (-f /usr/local/bin/less) then
   setenv PAGER '/usr/local/bin/less'
endif
#
# vi default options (user-selectable).
#
setenv EDITOR '/usr/ucb/vi'
setenv VISUAL '/usr/ucb/vi'
setenv EXINIT 'set ts=8 sw=8 autoindent redraw ignorecase wm=8'
#
# User-modifiable parameters:
# Users may change values of these parameters by re-issuing a "set ..."
# with the desired value, or "unset ..." to clear a "set" completely.
#
set history = 500	# number of commands kept in history buffer
set savehist = 250	# number of commands saved from this shell
set filec		# activate file name completion with ESC
set ignoreeof		# activate to prevent logout by ^D
set notify		# activate for immediate job completion notification 
umask 022		# file protection mask: owner:rwx group:r-x other:r-x
alias h history		# allow 'h' for 'history'
alias hg 'history | grep'	# grep through the command history
alias pd pushd		# allow 'pd' for 'pushd'
setenv MORE -cds	# default options for 'more'
alias page less		# normally make 'page' default to 'less'
alias zpage zmore 	# allow 'zpage' for 'zmore'
setenv LESS '-ceiMqsPM?f%f .?n?m(file %i of %m) ..?ltline %lt :byte %bB?s/%s ..?e(END) ?x- Next\: %x.:?pB%pB\%..%t [h for help]'  # default 'less' options
alias dviimp dviimp -b	# make dviimp print TeX/LaTeX in proper page order
#
# The following aliases allow for editing commands given in the csh.
#   e n  -  visual edits command n (as numbered by history)    
#   ee   -  visual edits last command
# Note: Both use an invisible work file called ".e_cmd" in the home directory.
# By Robert Kaminsky, 11/19/90
#
alias e "(history | sed -n '/^ *\!*[^0-9]/p' | \\
 sed 's/.......//') >&! $homepath/.e_cmd ; \\
 \vi -w002 $homepath/.e_cmd ; \\
 source -h $homepath/.e_cmd ; source $homepath/.e_cmd"
alias ee "(history | tail -2 | sed -n '1p' | \\
 sed 's/.......//') >&! $homepath/.e_cmd ; \\
 \vi -w002 $homepath/.e_cmd ; \\
 source -h $homepath/.e_cmd ; source $homepath/.e_cmd"
#
# The following aliases print out the command history in 2 and 3 column format.
# Modified from an idea by Robert Kaminsky, 11/19/90, following a
# suggestion by Markus Gyger (mgyger@itr.ch).
#
alias h2 '(history 30 | tail -30 | expand | cut -c1-36, | pr -2 -l15 -t)'
alias h3 '(history 45 | tail -45 | expand | cut -c1-24, | pr -3 -l15 -t)'
#
# Aliases for batch queueing system.
#
alias be batchexamine		# allow 'be' for 'batchexamine'.
alias bq batchqueue		# allow 'bq' for 'batchqueue'.
#
# Aliases for ls.
#
alias ll 'ls -lg'		# allow 'll' for 'ls -lg'.
alias lsf 'ls -F'		# allow 'lsf' for 'ls -F'.
alias lsr 'ls -R'		# allow 'lsr' for 'ls -R'.
alias llr 'll -R'		# allow 'llr' for 'll -R'.
alias dir 'echo Hey\! This is UNIX\! \\
 Well, OK... but just this once...; \\
 ls -lg'			# allow 'dir' for 'ls -lg'
				# (from UNIX Power Tools, O'Reilly).
#
# Alias for nice.
#
alias nice "/bin/nice"		# /bin/nice has more sensible arguments.
#
# Aliases for getting all processes that belong to a user,
# and for ps/grep (from Fred Mallett, HP Professional).
#
alias psu 'ps agux | grep $USER'	# expand $USER at execution time.
alias psg 'ps agux | grep -i'		# grep through the ps output.
#
# Useful stuff for X Windows:
#
# Use 'newsize' after re-sizing an xterm window.
# Use 'seltek' to convert an xterm from vt102 to Tektronix mode.
# Use 'selvt' to convert an xterm from Tektronix to vt102 mode.
# Use 'xtitle xxxxx' to set the window title.
# Use 'xicon xxxxx' to set the window icon name.
# Use 'xboth xxxxx' to set both the window title and icon name.
# Use 'xreset' to do a full reset.
# Use 'LO' to logout from an Apollo display.
# Set "tandem" and "tostop" modes for xterms (in case ~/.login not read).
#
if ("$?term" != "0") then
   if ("$term" == "xterm" || "$term" == "xterms" \
    || "$term" == "aixterm" || "$term" == "hpterm" \
    || "$term" == "iris-ansi-net") then
      alias newsize '(setenv SHELL /bin/csh; set noglob; eval `resize`; unset noglob)'
      alias seltek '(echo -n "E[?38h" | tr E \\033)'	# temp bug fix
      alias selvt '(echo -n "EC" | tr EC \\033\\003)'	# temp bug fix
      alias xtitle 'echo -n "]2;\!$"'		# set title
      alias xicon 'echo -n "]1;\!$"'		# set icon name
      alias xboth 'echo -n "]0;\!$"'		# set both
      alias xreset 'echo -n "c"'			# full reset
      alias LO 'dmwin xdmc lo'				# logout
      stty tandem tostop crt -tabs
   endif
endif
#
# USENET news stuff - note that Apollo uses $ORGANIZATION as part of
# their person.group.organization, but the following redefinition for
# news seems to cause no trouble.
#
setenv ORGANIZATION "University of Toronto Chemistry Department"
setenv RNINIT "-e -m -S -/"		# default options for rn.
setenv TRNINIT "-e -m -S -/ -p -G"	# default options for trn.
#
# Prepare for ksh scripts by setting ENV, HISTFILE and HISTSIZE.
#
setenv ENV $homepath/.kshrc	# default ksh startup file
setenv HISTFILE $homepath/.sh_history	# history file
setenv HISTSIZE 250		# number of commands kept in history buffer
#
# CRISP stuff, set up for running under X-windows using the 'xcr' alias.
# The BBACKUP stuff won't work unless the directory is created manually.
#
setenv CRISP_ROOT /usr/local/crisp
setenv BHELP $CRISP_ROOT/help
setenv BPATH $CRISP_ROOT/macros
setenv BTERMCAP $CRISP_ROOT/utils/termcap
setenv BBACKUP $homepath/crisp/backup
setenv BVERSION 3
alias xcr 'xterm -name xcrisp -title xcrisp -e /bin/csh -c cr'
#
# Set the BTERM and BKBD environment variables.  We assume that if
# the terminal type is "vtNNN" then we are using the MS-kermit terminal
# emulator, and thus set BTERM accordingly.
#
if ("$?term" != "0") then
   if ("$term" == "xterm") then
      setenv BKBD xterm
      setenv BTERM xcrisp
   else if ("$term" == "aixterm") then
      setenv BKBD xterm
      setenv BTERM aixcrisp
   else if ("$term" == "vt100" || "$term" == "vt102" || \
    "$term" == "vt220" || "$term" == "vt320") then
      setenv BTERM kermit
   else
      setenv BTERM $term
   endif
endif
