#
# Master.kshrc file - run for every Korn shell.
#
# Version: 1995/05/23.
#
# Author: Mike Peterson, Department of Chemistry, University of Toronto.
#         <system@alchemy.chem.utoronto.ca>
#
#
# Put all the Korn shell stuff here, even if it should logically
# go with other stuff in .profile.
#
# Set default directory search path.
#
CDPATH=".:..:$HOME"
export CDPATH
#
# Allow convenient directory change.
# From Markus Gyger, Interkantonales Technikum, Switzerland (mgyger@itr.ch).
#
alias -x ..='cd ..'
#
# Prompt generator.
#
host=`hostname`
PS1=${host}:'${PWD}\$ '
export PS1
#
# Set default history editor.
#
set -o vi
FCEDIT=/usr/ucb/vi
export FCEDIT
#
# Set the history file location and size if not already set.
#
if [ "$HISTFILE" = "" ]; then
   if [ "$HOME" != "/" ]; then
      HISTFILE=$HOME/.sh_history
   else
      HISTFILE=/.sh_history
   fi
fi
if [ "$HISTSIZE" = "" ]; then
   HISTSIZE=250
fi
export HISTFILE HISTSIZE
#
# Mail parameters.
#
MAILCHECK=60			# check mail every 60 seconds
MAILPATH=/usr/spool/mail/${USER}
export MAILCHECK MAILPATH
#
# User-modifiable parameters:
# Users may change values of these parameters by re-issuing a "set ..."
# with the desired value, or "unset ..." to clear a "set" completely.
#
set -o ignoreeof		# activate to prevent logout by ^D
set -o trackall			# activate for faster command search
alias -x h="fc -l"		# allow 'h' for 'history'
alias -x hg='fc -l | grep'	# grep through the command history
alias -x !!="fc -e -"		# allow '!!' to repeat last command
alias -x page=less		# normally make 'page' default to 'less'
alias -x zpage=zmore 		# allow 'zpage' for 'zmore'
alias -x dviimp="dviimp -b"	# make dviimp print TeX/LaTeX in proper page order
#
# The following aliases print out the command history in 2 and 3 column format.
# Modified from an idea by Robert Kaminsky, 11/19/90, following a
# suggestion by Markus Gyger (mgyger@itr.ch).
#
alias -x h2='fc -l -30 | tail -30 | expand | cut -c1-4,8-36, | pr -2 -l15 -t'
alias -x h3='fc -l -45 | tail -45 | expand | cut -c1-4,8-24, | pr -3 -l15 -t'
#
# Aliases for batch queueing system.
#
alias -x be=batchexamine	# allow 'be' for 'batchexamine'.
alias -x bq=batchqueue		# allow 'bq' for 'batchqueue'.
#
# Aliases for ls.
#
alias -x ll='ls -lg'		# allow 'll' for 'ls -lg'.
alias -x lsf='ls -F'		# allow 'lsf' for 'ls -F'.
alias -x lsr='ls -R'		# allow 'lsr' for 'ls -R'.
alias -x llr='ll -R'		# allow 'llr' for 'll -R'.
alias -x dir='echo Hey! This is UNIX! \
 Well, OK... but just this once...; \
 ls -lg'			# allow 'dir' for 'ls -lg'
				# (from UNIX Power Tools, O'Reilly).
#
# Alias for nice.
#
alias -x nice='/bin/nice'	# /bin/nice has more sensible arguments.
#
# Aliases for getting all processes that belong to a user,
# and for ps/grep (from Fred Mallett, HP Professional).
#
alias -x psu='ps agux | grep $USER'	# expand $USER at execution time.
alias -x psg='ps agux | grep -i'	# grep through the ps output.
#
# Useful stuff for X Windows:
#
# Use 'newsize' after re-sizing an xterm window.
# Use 'seltek' to convert an xterm from vt102 to Tektronix mode.
# Use 'selvt' to convert an xterm from Tektronix to vt102 mode.
# Use 'xtitle xxxxx' to set the window title.
# Use 'xicon xxxxx' to set the window icon name.
# Use 'xboth xxxxx' to set both the window title and icon name.
# Use 'xreset' to do a full reset.
# Use 'LO' to logout from an Apollo display.
# Set "tandem" and "tostop" modes for xterms (in case ~/.login not read).
#
if [ "$TERM" = "xterm" -o "$TERM" = "xterms" \
 -o "$TERM" = "aixterm" -o "$TERM" = "hpterm" \
 -o "$TERM" = "iris-ansi-net" ]; then
   alias -x newsize='(SHELL=/bin/ksh; export SHELL; set noglob; eval `resize`; unset noglob)'
   alias -x seltek='(echo -n "E[?38h" | tr E \\033)'	# temp bug fix
   alias -x selvt='(echo -n "EC" | tr EC \\033\\003)'	# temp bug fix
   xtitle() { echo -n "]2;$*"; }			# set title
   xicon() { echo -n "]1;$*"; }			# set icon name
   xboth() { echo -n "]0;$*"; }			# set both
   xreset() { echo -n "c"; }				# full reset
   alias -x LO='dmwin xdmc lo'
   stty tandem tostop -tabs
fi
#
# CRISP alias.
#
alias -x xcr='xterm -name xcrisp -title xcrisp -e /bin/csh -c cr'
