#
# Master.login file - run for every C shell interactive login.
#
# Version: 1995/05/23.
#
# Author: Mike Peterson, Department of Chemistry, University of Toronto.
#         <system@alchemy.chem.utoronto.ca>
#
#
# This script is used with an optional variable 'favterm' which is the
# users favorite terminal type (assume 'vt100' if not given).
#
if ("$?favterm" == "0") set favterm = vt100
#
# Handle the $HOME variable for root users.
#
if ("$HOME" != "/") then
   set homepath = $HOME
else
   set homepath =
endif
#
# Set terminal characteristics - change rprnt from ^R to ^_ to allow
# redraw in vi.
# Also set the speed to 9600 since telnetd doesn't get the proper speed.
# Only do this for pseudo-tty's to avoid lots of problems.
# On old versions of Domain/OS, it was necessary to set 'rows 0 columns 0'
# to the stty command below because the previous terminal settings would
# be retained sometimes; with SR10.4 try to preserve the incoming settings.
#
set rows = `stty size`
if ("$#rows" == "2") then
   set cols = $rows[2]
   set rows = $rows[1]
else
   set rows = 0
   set cols = 0
endif
stty -tabs erase ^H kill ^U intr ^C rprnt ^_ crt tostop tandem
set device = "`tty`"
egrep -s 'ttyp|ttyq|ttyr|ttys' <<EOF
$device
EOF
if ( "$status" == "0" ) then
   stty 9600
endif
unset device
#
# Set terminal type and get $TERMCAP.
# An extra 'stty -tabs' is required due to a problem in tset.
# Ignore all this stuff for an Apollo display.
# Handle xterms specially (force the proper window size).
#
if ("$term" != "apollo" && "$term" != "apollo_1280_color" && "$term" != "apollo_15_color") then
   set noglob
   if ("$term" == "su") set term = $favterm
   set term = (`tset -Q -I -S ?$term`)
   setenv TERMCAP $term[2]
   set term = $term[1]
   stty -tabs
   unset noglob
   if ("$term" == "xterm" || "$term" == "xterms" \
    || "$term" == "aixterm" || "$term" == "hpterm" \
    || "$term" == "iris-ansi-net") then
      if (-f /usr/bin/X11/resize) then
	 set noglob
	 eval `/usr/bin/X11/resize`
	 unset noglob
      else
	 echo "*** Trouble: no X11 'resize' for xterm - setting 24/80 ***"
	 stty rows 24 columns 80
      endif
   else
      if ("$rows" > "0" && "$cols" > "0") then
         stty rows $rows columns $cols
      endif
   endif
endif
unset rows cols
#
# Check to see if a system save is in progress on either this node or
# the users "home" node - if so, ask the user if they really want to login.
#
if (-e /usr/local/SAVEINPROGRESS) then
   echo " "
   echo "******************************************"
   echo "A system save is in progress on this node."
   echo "******************************************"
   echo " "
   echo -n "Do you really want to login (reply 'y'<CR> if yes) ? "
   set response = $<
   echo " "
   if ("$response" != "y") then
      echo "Congratulations on an excellent choice \!\!\!"
      sleep 2
      logout
   endif
   echo "Login permitted, but I hope you don't regret your choice \!\!\!"
   echo " "
   unset response
else if ("$HOME" != "/") then
   if (-e $HOME/../../usr/local/SAVEINPROGRESS) then
      echo " "
      echo "***********************************************"
      echo "A system save is in progress on your home node."
      echo "***********************************************"
      echo " "
      echo -n "Do you really want to login (reply 'y'<CR> if yes) ? "
      set response = $<
      echo " "
      if ("$response" != "y") then
         echo "Congratulations on an excellent choice \!\!\!"
         sleep 2
         logout
      endif
      echo "Login permitted, but I hope you don't regret your choice \!\!\!"
      echo " "
      unset response
   endif
endif
#
# Display last login info.
#
if (-f "$homepath/.lastlogin") then
   cat $homepath/.lastlogin
endif
set loginhost=`who am i | sed -e 's/.*(//' -e 's/).*$//' -e 's/\.chem\.utoronto\.ca$//'`
if ("$#loginhost" != "1") then
   set loginhost="display $DISPLAY"
endif
echo "Last login: `date` on `hostname` from $loginhost." >! $homepath/.lastlogin
unset loginhost
#
# Other useful stuff.
#
mesg y
msgs -f
#
# Optional (user-selectable) parameters and commands.
#
biff y
set mail=(60 /usr/spool/mail/$USER)
cd
#
unset homepath
