#
# Makefile file - used for C and/or Fortran compilations.
#
# Version: 1995/05/23.
#
# Author: Mike Peterson, Department of Chemistry, University of Toronto.
#         <system@alchemy.chem.utoronto.ca>
#
#
# This Makefile expects an environment variable $FLOAT, which should
# be set in your ~/.cshrc or ~/.profile file to the appropriate string
# to activate any desired floating point options that need to be passed
# to the compilers.
#
# On the HP (HP-UX), $FLOAT is not used, and can be left as a null string.
# The cc compiler also uses the environment variable $CCOPTS, which can
# be set for any desired cc options (see the cc manual/man page).
# The f77 compiler also uses the environment variable $FCOPTS, which can
# be set for any desired f77 options (see the f77 manual/man page).
#
# On the Apollo (Domain/OS), the valid possibilities are:
#     $FLOAT = '-A cpu,3000'  - compile for any 680x0-based node.
#     $FLOAT = '-A cpu,fpa1'  - compile for a 680x0+fpa node.
#     $FLOAT = '-A cpu,a88k'  - compile for any PRISM-based node.
# You may want to incorporate the above option into any user-written
# Makefiles (via CFLAGS/FFLAGS below) to take maximum advantage
# of the system you use.
#
# Expected naming conventions:
# *.a - archive/library files.
# *.c - C source files.
# *.e - Efl source files.
# *.f - Fortran source files.
# *.h - Header (include) source files.
# *.l - Lex source files.
# *.o - object files.
# *.r - Ratfor source files.
# *.s - Assembler source files.
# *.y - Yacc-C source files.
# *   - executable files (no suffix).
#
# Set default compiler names:
#
FC=f77
#
# Set desired default options here:
# $(CFLAGS): C compilation options.
# $(FFLAGS): Fortran compilation options.
# $(LFLAGS): Lex options.
# $(MFLAGS): Command line options.
# $(YFLAGS): Yacc options.
# $(LDFLAGS): Loader options.
#
# Activate the following for debugging of your code (add -C to the
# FFLAGS for subscript checking at execution time):
#
CFLAGS = -g $$FLOAT
FFLAGS = -g $$FLOAT
#
# Activate the following for optimization of your code (make sure
# your code works properly with no optimization first):
#
#CFLAGS = -O $$FLOAT
#FFLAGS = -O $$FLOAT
#
# Activate the following for super-optimization of your code (make sure
# your code works properly with no optimization first, and don't use
# this for code to be put into libraries since the compiler will in-line
# your subroutines):
#
# HP (also check out the FORTRAN pre-processor options +OPn):
#CFLAGS = +O3 $$FLOAT
#FFLAGS = +O3 $$FLOAT
#
# Apollo:
#CFLAGS = -W0,'-opt,4' $$FLOAT
#FFLAGS = -W0,'-opt 4' $$FLOAT
#
# You can set ld flags here, or add to the list of libraries (put other
# system libraries ahead of -luttcs):
#
LDFLAGS = -luttcs -lutchem -lm
#
# Activate the following line if you have personal libraries, and have
# defined the environment variable $LIBDIR to point to the directory
# that contains them (e.g. "~/lib"). Put your libraries ahead of 
# -luttcs in the form '-lname':
#
#LDFLAGS = -L$$LIBDIR -luttcs -lutchem -lm
#
# Define a default .f rule with the arguments in the proper order
# (broken on some versions of Domain/OS and HP-UX):
#
.f:
	$(FC) $(FFLAGS) $< $(LDFLAGS) -o $@
	-rm -f $*.o
#
# Default action: do nothing.
#
nothing:
	@echo "No make target specified - nothing made."
	@echo "Usage: make foo"
	@echo "or     make 'CFLAGS=... %%FLOAT' foo"
	@echo "or     make 'FFLAGS=... %%FLOAT' foo"
	@echo "where the '%' are replaced by '$$'."
#
# Clean *.o and core files from the current directory.
# Usage: make clean.
#
clean:
	-rm -f *.o core
