#
# Master.profile file - run for every Bourne/Korn shell login.
#
# Version: 1995/05/23.
#
# Author: Mike Peterson, Department of Chemistry, University of Toronto.
#         <system@alchemy.chem.utoronto.ca>
#
#
# Set default path.
#
PATH="/usr/local/binspecial:/usr/ucb:/bin:/usr/bin:/usr/bin/X11"
PATH="$PATH:/usr/local/bin:/usr/apollo/bin:/etc:/usr/etc"
host=`hostname`
#
# Add the personal bin directories ~/bin (for scripts) and ~/bin/apollo
# (for executables)for non-root users.
#
if [ "$HOME" != "/" ]; then
   PATH="$PATH:$HOME/bin:$HOME/bin/apollo"
   homepath=$HOME
else
   homepath=
fi
#
# Put the current directory last.
#
PATH="$PATH:"
export PATH
#
MAIL=/usr/spool/mail/$USER
export MAIL
#
# Prompt generator.
#
PS1="${host}\$ "
PS2="> "
export PS1 PS2
#
# Set the default floating point option $FLOAT based on the node type
# and node name.
#
if [ "$NODETYPE" = "DN10000" -o "$NODETYPE" = "DSP10000" ]; then
   FLOAT='-A cpu,a88k'
elif [ $host = todah ]; then
   FLOAT='-A cpu,fpa1 -W0,-frnd'
else
   FLOAT='-A cpu,3000 -W0,-frnd'
fi
export FLOAT
#
# Set default printer name.
#
PRINTER='imagen'
export PRINTER
#
# Set the default X Windows server name - set to the name of the host
# the user logged in from, unless it was the terminal server (ventus).
# Also strip off the local domain name (.chem.utoronto.ca) if possible.
# If $DISPLAY is already set, leave it alone.
#
if [ "$DISPLAY" = "" ]; then
   DISPLAY=${host}:0
   set `who am i | sed -e 's/.*(//' -e 's/).*$//' -e 's/\.chem\.utoronto\.ca$//'`
   if [ "$#" = "1" ]; then
      if [ "$1" != "ventus" ]; then
         DISPLAY=$1\:0
      fi
   fi
fi
export DISPLAY
#
# User-modifiable parameters:
#
umask 022		# file protection mask: owner:rwx group:r-x other:r-x
#
# This script is used with an optional variable 'favterm' which is the
# users favorite terminal type (assume '914' if not given).
#
favterm="${favterm=914}"
#
# Set terminal characteristics - change rprnt from ^R to ^_ to allow
# redraw in vi.
# Also set the speed to 9600 since telnetd doesn't get the proper speed.
# Only do this for pseudo-tty's to avoid lots of trouble.
# On old versions of Domain/OS, it was necessary to set 'rows 0 columns 0'
# to the stty command below because the previous terminal settings would
# be retained sometimes; with SR10.4 try to preserve the incoming settings.
#
set `stty size`
if [ "$#" = "2" ]; then
   rows=$1
   cols=$2
else
   rows=0
   cols=0
fi
stty -tabs erase \^H kill \^U intr \^C rprnt \^_ crt tostop tandem
device="`tty`"
egrep -s 'ttyp|ttyq|ttyr|ttys' <<EOF
$device
EOF
if [ "$?" = "0" ]; then
   stty 9600
fi
#
# Set terminal type and get $TERMCAP.
# An extra 'stty -tabs' is required due to a problem in tset.
#
if [ "$TERM" != "apollo" -a "$TERM" != "apollo_1280_color" -a \
 "$TERM" != "apollo_15_color" ]; then
   if [ "$TERM" = "su" ]; then
      TERM="$favterm"
   fi
   eval `tset -Q -I -S ?$TERM`
   stty -tabs
   if [ "$TERM" = "xterm" -o "$TERM" = "xterms" \
    -o "$TERM" = "aixterm" -o "$TERM" = "hpterm" \
    -o "$TERM" = "iris-ansi-net" ]; then
      if [ -x /usr/bin/X11/resize ]; then
         eval `/usr/bin/X11/resize`
         eval `/usr/bin/X11/resize`
      else
         echo "*** Trouble: no X11 'resize' for xterm - setting 24/80 ***"
         stty rows 24 columns 80
      fi
   else
      if [ "$rows" -gt "0" -a "$cols" -gt "0" ]; then
         stty rows $rows columns $cols
      fi
   fi
fi
#
# Check to see if a system save is in progress on either the users "home"
# node or this node - if so, ask the user if they really want to login.
#
if [ -f /usr/local/SAVEINPROGRESS ]; then
   echo " "
   echo "******************************************"
   echo "A system save is in progress on this node."
   echo "******************************************"
   echo " "
   echo -n "Do you really want to login (reply 'y'<CR> if yes) ? "
   read response
   echo " "
   if [ "$response" != "y" ]; then
      echo "Congratulations on an excellent choice !!!"
      sleep 2
      logout
   fi
   echo "Login permitted, but I hope you don't regret your choice !!!"
   echo " "
elif [ "$HOME" != "/" ]; then
   if [ -f $HOME/../../usr/local/SAVEINPROGRESS ]; then
      echo " "
      echo "***********************************************"
      echo "A system save is in progress on your home node."
      echo "***********************************************"
      echo " "
      echo -n "Do you really want to login (reply 'y'<CR> if yes) ? "
      read response
      echo " "
      if [ "$response" != "y" ]; then
         echo "Congratulations on an excellent choice !!!"
         sleep 2
         logout
      fi
      echo "Login permitted, but I hope you don't regret your choice !!!"
      echo " "
   fi
fi
#
# man paging program default (user-selectable).
#
if [ -f /usr/local/bin/less ]; then
   PAGER='/usr/local/bin/less'
   export PAGER
fi
#
# vi default options (user-selectable).
#
EDITOR='/usr/ucb/vi'
VISUAL='/usr/ucb/vi'
EXINIT='set ts=8 sw=8 autoindent redraw ignorecase wm=8'
export EDITOR VISUAL EXINIT
#
# Display last login info.
#
if [ -f "$homepath/.lastlogin" ]; then
   cat $homepath/.lastlogin
fi
set `who am i | sed -e 's/.*(//' -e 's/).*$//' -e 's/\.chem\.utoronto\.ca$//'`
if [ "$#" = "1" ]; then
   loginhost="$1"
else
   loginhost="display $DISPLAY"
fi
echo "Last login: `date` on $hostname from $loginhost." >$homepath/.lastlogin
#
# Other useful stuff.
#
mesg y
msgs -f
#
# Optional (user-selectable) parameters and commands.
#
biff y
MORE='-cds'
export MORE
LESS='-ceiMqsPM?f%f .?n?m(file %i of %m) ..?ltline %lt :byte %bB?s/%s ..?e(END) ?x- Next\: %x.:?pB%pB\%..%t [h for help]'
export LESS
#
# USENET news stuff - note that Apollo uses $ORGANIZATION as part of
# their person.group.organization, but the following redefinition for
# news seems to cause no trouble.
#
ORGANIZATION='University of Toronto Chemistry Department'
RNINIT='-e -m -S -/'		# default options for rn.
TRNINIT='-e -m -S -/ -p -G'	# default options for trn.
export ORGANIZATION RNINIT TRNINIT
#
# CRISP stuff, set up for running under X-windows using the 'xcr' alias.
# The BBACKUP stuff won't work unless the directory is created manually.
#
CRISP_ROOT=/usr/local/crisp
BHELP=$CRISP_ROOT/help
BPATH=$CRISP_ROOT/macros
BTERMCAP=$CRISP_ROOT/utils/termcap
BBACKUP=$homepath/crisp/backup
BVERSION=3
export CRISP_ROOT BHELP BPATH BTERMCAP BVERSION
#
# Set the BTERM and BKBD environment variables.  We assume that if
# the terminal type is "vtNNN" then we are using the MS-kermit terminal
# emulator, and thus set BTERM accordingly.
#
if [ "$TERM" = "xterm" ]; then
   BKBD=xterm
   BTERM=xcrisp
elif [ "$TERM" = "aixterm" ]; then
   BKBD=xterm
   BTERM=aixcrisp
elif [ "$TERM" = "vt100" -o "$TERM" = "vt102" -o \
 "$TERM" = "vt220" -o "$TERM" = "vt320" ]; then
   BTERM=kermit
else
   BTERM=$TERM
fi
export BKBD BTERM
#
# Put all the Korn shell stuff here, even if it should logically
# go with other stuff above.
#
# Prepare for ksh scripts by setting ENV, HISTFILE and HISTSIZE.
#
ENV=$homepath/.kshrc	# default ksh startup file
HISTFILE=$homepath/.sh_history	# history file
HISTSIZE=250		# number of commands kept in history buffer
export ENV HISTFILE HISTSIZE
#
if [ "$SHELL" = "/bin/ksh" ]; then
#
# Execute ~/.logout when the user exits the shell.
#
   trap ". $homepath/.logout ; exit" EXIT
fi
#
cd
