/*	NGT -- Network Graphics Terminal for Apollo Emacs using GPR	     */
/*									     */
/*	Copyright (C) 1987 by Leonard N. Zubkoff, All Rights Reserved	     */
/*									     */
/*	This software is provided free and without any warranty.	     */
/*	Permission to copy for any purpose is hereby granted so		     */
/*	long as this copyright notice remains intact.			     */
/*									     */
/*	Revision:	15-Feb-92 13:22:01				     */


#define C_InitializeTerminal		0x00
#define C_ResetTerminal			0x01
#define C_IconizeTerminal		0x02
#define C_RingBell			0x03
#define C_DefineWindow			0x04
#define C_ClearScreen			0x05
#define C_ClearToEndOfLine		0x06
#define C_ClearToEndOfWindow		0x07
#define C_HomeCursor			0x08
#define C_CursorDownAndReturn		0x09
#define C_CursorDownAndWriteColumn	0x0A
#define C_WriteCursorPosition		0x0B
#define C_DeleteCharacters		0x0C
#define C_OpenSpaces			0x0D
#define C_InsertSpaces			0x0E
#define C_OverwriteSpaces		0x0F
#define C_OverwriteCharacters		0x10
#define C_DeleteLines			0x11
#define C_InsertLines			0x12
#define C_HighlightModeOn		0x13
#define C_HighlightModeOff		0x14
#define C_EnableApolloFunctionKey	0x15
#define C_DisableApolloFunctionKey	0x16
#define C_EnableApolloMouseButton	0x17
#define C_DisableApolloMouseButton	0x18
#define C_SetApolloMetaKey		0x19
#define C_WritePasteBuffer		0x1A
#define C_ReadPasteBuffer		0x1B
#define C_ExecuteDMCommand		0x1C

#define L_DefineAndDisplayDynamicToken	0x90
#define U_DefineAndDisplayDynamicToken	0xBF
#define L_DisplayDynamicToken		0xC2
#define U_DisplayDynamicToken		0xC7
#define L_DisplayStaticToken		0xC8
#define U_DisplayStaticToken		0xDF
#define L_DisplayQuickToken		0xE0
#define U_DisplayQuickToken		0xFF


#define N_Keystroke			0x00
#define N_FunctionKey			0x01
#define N_Buttons			0x02
#define N_Refresh			0x03
#define N_SetObscured			0x04
#define N_PasteBuffer			0x05


#define DefineCommandArgumentCounts					    \
  static char CommandArgumentCounts[256] =				    \
    { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 2, 1, 1, 1, 1,			    \
      2, 2, 2, 0, 0, 1, 1, 1, 1, 1, 3, 0, 9, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,			    \
      8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,			    \
      8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,			    \
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,			    \
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,			    \
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }


#define Z_InitializeTerminal()						    \
  {									    \
    OutputByte(C_InitializeTerminal);					    \
  }


#define Z_ResetTerminal()						    \
  {									    \
    OutputByte(C_ResetTerminal);					    \
  }


#define Z_IconizeTerminal()						    \
  {									    \
    OutputByte(C_IconizeTerminal);					    \
  }


#define Z_RingBell()							    \
  {									    \
    OutputByte(C_RingBell);						    \
  }


#define Z_DefineWindow(WindowLines)					    \
  {									    \
    OutputByte(C_DefineWindow);						    \
    OutputByte((WindowLines));						    \
  }


#define Z_ClearScreen()							    \
  {									    \
    OutputByte(C_ClearScreen);						    \
  }


#define Z_ClearToEndOfLine()						    \
  {									    \
    OutputByte(C_ClearToEndOfLine);					    \
  }


#define Z_ClearToEndOfWindow()						    \
  {									    \
    OutputByte(C_ClearToEndOfWindow);					    \
  }


#define Z_HomeCursor()							    \
  {									    \
    OutputByte(C_HomeCursor);						    \
  }


#define Z_CursorDownAndReturn()						    \
  {									    \
    OutputByte(C_CursorDownAndReturn);					    \
  }


#define Z_CursorDownAndWriteColumn(Column)				    \
  {									    \
    OutputByte(C_CursorDownAndWriteColumn);				    \
    OutputByte((Column));						    \
  }


#define Z_WriteCursorPosition(Line,Column)				    \
  {									    \
    OutputByte(C_WriteCursorPosition);					    \
    OutputByte((Line));							    \
    OutputByte((Column));						    \
  }


#define Z_DeleteCharacters(DeleteCount)					    \
  {									    \
    OutputByte(C_DeleteCharacters);					    \
    OutputByte((DeleteCount));						    \
  }


#define Z_OpenSpaces(OpenCount)						    \
  {									    \
    OutputByte(C_OpenSpaces);						    \
    OutputByte((OpenCount));						    \
  }


#define Z_InsertSpaces(InsertCount)					    \
  {									    \
    OutputByte(C_InsertSpaces);						    \
    OutputByte((InsertCount));						    \
  }


#define Z_OverwriteSpaces(OverwriteCount)				    \
  {									    \
    OutputByte(C_OverwriteSpaces);					    \
    OutputByte((OverwriteCount));					    \
  }


#define Z_OverwriteCharacters(OverwriteCount,OverwriteCharacter)	    \
  {									    \
    OutputByte(C_OverwriteCharacters);					    \
    OutputByte((OverwriteCount));					    \
    OutputByte((OverwriteCharacter));					    \
  }


#define Z_DeleteLines(Line,DeleteCount)					    \
  {									    \
    OutputByte(C_DeleteLines);						    \
    OutputByte((Line));							    \
    OutputByte((DeleteCount));						    \
  }


#define Z_InsertLines(Line,InsertCount)					    \
  {									    \
    OutputByte(C_InsertLines);						    \
    OutputByte((Line));							    \
    OutputByte((InsertCount));						    \
  }


#define Z_HighlightModeOn()						    \
  {									    \
    OutputByte(C_HighlightModeOn);					    \
  }


#define Z_HighlightModeOff()						    \
  {									    \
    OutputByte(C_HighlightModeOff);					    \
  }


#define Z_EnableApolloFunctionKey(KeyCode)				    \
  {									    \
    OutputByte(C_EnableApolloFunctionKey);				    \
    OutputByte((KeyCode));						    \
  }


#define Z_DisableApolloFunctionKey(KeyCode)				    \
  {									    \
    OutputByte(C_DisableApolloFunctionKey);				    \
  }


#define Z_EnableApolloMouseButton(KeyCode)				    \
  {									    \
    OutputByte(C_EnableApolloMouseButton);				    \
    OutputByte((KeyCode));						    \
  }


#define Z_DisableApolloMouseButton(KeyCode)				    \
  {									    \
    OutputByte(C_DisableApolloMouseButton);				    \
    OutputByte((KeyCode));						    \
  }


#define Z_SetApolloMetaKey(KeyCode)					    \
  {									    \
    OutputByte(C_SetApolloMetaKey);					    \
    OutputByte((KeyCode));						    \
  }


#define Z_ReadPasteBuffer()						    \
  {									    \
    OutputByte(C_ReadPasteBuffer);					    \
  }


#define Z_WritePasteBuffer(Length)					    \
  {									    \
    int ByteCount = (Length);						    \
    OutputByte(C_WritePasteBuffer);					    \
    OutputByte((ByteCount>>16));					    \
    OutputByte((ByteCount>>8));						    \
    OutputByte((ByteCount));						    \
  }


#define Z_ExecuteDMCommand(Length)					    \
  {									    \
    OutputByte(C_ExecuteDMCommand);					    \
    OutputByte((Length));						    \
  }


#define Z_DefineAndDisplayDynamicToken(TokenType,ByteCount)		    \
  {									    \
    OutputByte(0x80 | ((TokenType)<<3) | ((ByteCount)-1));		    \
  }


#define Z_DisplayDynamicToken(TokenNumber,TokenType)			    \
  {									    \
    OutputByte(0xC0 | (TokenType));					    \
    OutputByte((TokenNumber));						    \
  }


#define Z_DisplayStaticToken(TokenNumber,TokenType)			    \
  {									    \
    OutputByte(0xC0 | ((TokenType)<<2) | ((TokenNumber)>>8));		    \
    OutputByte((TokenNumber) & 0xFF);					    \
  }


#define Z_DisplayQuickToken(TokenNumber)				    \
  {									    \
    OutputByte(0xE0 | ((TokenNumber)&0x1F));				    \
  }
