/*	TXTCMP -- Text Compression Module				     */
/*									     */
/*	Copyright (C) 1985 by Leonard N. Zubkoff, All Rights Reserved	     */
/*									     */
/*	This software is provided free and without any warranty.	     */
/*	Permission to copy for any purpose is hereby granted so		     */
/*	long as this copyright notice remains intact.			     */
/*									     */
/*	Revision:	15-Feb-92 16:17:37				     */


hidden int
  NextDynamicTokenNumber;


struct TokenNode
  {
    /* Next must be offset 0 into this structure. */
    struct TokenNode *Next, *Prev;
    word Token0, Token1;
  };


hidden struct TokenNode
  *HashTable[256],
  Nodes[256];


hidden boolean
  BigEndian;


union TokenWords
  {
    word Words[2];
    byte Characters[8];
  };


hidden byte
  Nibbles[26] =
    { 6, 3, 11, 12, 1, 1, 2, 10, 3, 9, 7, 9, 13,
      5, 4, 15, 10, 8, 7, 2, 14, 6, 5, 8, 4, 11 };


hidden boolean
  PrefixedNibble[26] =
    { false, true, false, false, false, true, true, false, false,
      true, true, false, false, false, false, false, true, false,
      false, false, false, true, true, true, true, true };


hidden byte
  Shifts[8] =
    { 4, 0, 12, 8, 20, 16, 28, 24 };

hidden int LookupToken(Token0,Token1,TokenType,
		       TokenByteCount,OutputBuffer)
     register word Token0, Token1;
     int TokenType, TokenByteCount;
     byte *OutputBuffer;
{
  register byte *OutputPointer = OutputBuffer;
  register word *Pointer;
  int StaticToken = -1;
  union TokenWords Token;
  Token.Words[0] = Token0;
  Token.Words[1] = Token1;
  switch (TokenByteCount)
    {
      case 1:
	Pointer = StaticTable1;
	if (Token0 >= Pointer[8]) Pointer += StaticTable1Size - 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	if (Token0 == Pointer[0])
	  StaticToken = StaticTable1Base + Pointer-StaticTable1;
	break;
      case 2:
	Pointer = StaticTable2;
	if (Token0 >= Pointer[64]) Pointer += StaticTable2Size - 64;
	if (Token0 >= Pointer[32]) Pointer += 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	if (Token0 == Pointer[0])
	  StaticToken = StaticTable2Base+ Pointer-StaticTable2;
	break;
      case 3:
	Pointer = StaticTable3;
	if (Token0 >= Pointer[128]) Pointer += StaticTable3Size - 128;
	if (Token0 >= Pointer[64]) Pointer += 64;
	if (Token0 >= Pointer[32]) Pointer += 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	if (Token0 == Pointer[0])
	  StaticToken = StaticTable3Base + Pointer-StaticTable3;
	break;

      case 4:
	Pointer = StaticTable4;
	if (Token0 >= Pointer[128]) Pointer += StaticTable4Size - 128;
	if (Token0 >= Pointer[64]) Pointer += 64;
	if (Token0 >= Pointer[32]) Pointer += 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	if (Token0 == Pointer[0])
	  StaticToken = StaticTable4Base + Pointer-StaticTable4;
	break;
      case 5:
	Pointer = StaticTable5;
	if (Token0 >= Pointer[128]) Pointer += StaticTable5Size - 128;
	if (Token0 >= Pointer[64]) Pointer += 64;
	if (Token0 >= Pointer[32]) Pointer += 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	while (Token0 == Pointer[0])
	  if (Token1 == Pointer[StaticTable5Size])
	    {
	      StaticToken = StaticTable5Base + Pointer-StaticTable5;
	      break;
	    }
	  else --Pointer;
	break;
      case 6:
	Pointer = StaticTable6;
	if (Token0 >= Pointer[64]) Pointer += StaticTable6Size - 64;
	if (Token0 >= Pointer[32]) Pointer += 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	while (Token0 == Pointer[0])
	  if (Token1 == Pointer[StaticTable6Size])
	    {
	      StaticToken = StaticTable6Base + Pointer-StaticTable6;
	      break;
	    }
	  else --Pointer;
	break;

      case 7:
	Pointer = StaticTable7;
	if (Token0 >= Pointer[32]) Pointer += StaticTable7Size - 32;
	if (Token0 >= Pointer[16]) Pointer += 16;
	if (Token0 >= Pointer[8]) Pointer += 8;
	if (Token0 >= Pointer[4]) Pointer += 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	while (Token0 == Pointer[0])
	  if (Token1 == Pointer[StaticTable7Size])
	    {
	      StaticToken = StaticTable7Base + Pointer-StaticTable7;
	      break;
	    }
	  else --Pointer;
	break;
      case 8:
	Pointer = StaticTable8;
	if (Token0 >= Pointer[4]) Pointer += StaticTable8Size - 4;
	if (Token0 >= Pointer[2]) Pointer += 2;
	if (Token0 >= Pointer[1]) Pointer += 1;
	while (Token0 == Pointer[0])
	  if (Token1 == Pointer[StaticTable8Size])
	    {
	      StaticToken = StaticTable8Base + Pointer-StaticTable8;
	      break;
	    }
	  else --Pointer;
	break;
    }
  if (StaticToken >= 0)
    {
      register word TokenInstance = (StaticToken<<3) + TokenType;
      Pointer = QuickTable;
      if (TokenInstance >= Pointer[16])
	Pointer += QuickTableSize - 16;
      if (TokenInstance >= Pointer[8]) Pointer += 8;
      if (TokenInstance >= Pointer[4]) Pointer += 4;
      if (TokenInstance >= Pointer[2]) Pointer += 2;
      if (TokenInstance >= Pointer[1]) Pointer += 1;
      if (TokenInstance == Pointer[0])
	Z_DisplayQuickToken(Pointer-QuickTable)
      else Z_DisplayStaticToken(StaticToken,TokenType);
      goto Done;
    }

  {
    register struct TokenNode *HashEntry, *Node;
    HashEntry =
      (struct TokenNode *) &HashTable[Token.Characters[0]^Token.Characters[1]];
    Node = HashEntry;
    while ((Node = Node->Next) != 0)
      if (Token0 == Node->Token0 && Token1 == Node->Token1)
	{
	  Z_DisplayDynamicToken(Node-Nodes,TokenType);
	  goto Done;
	}
    Node = &Nodes[NextDynamicTokenNumber];
    if (Node->Next != 0)
      Node->Next->Prev = Node->Prev;
    if (Node->Prev != 0)
      Node->Prev->Next = Node->Next;
    Node->Next = HashEntry->Next;
    Node->Prev = HashEntry;
    if (HashEntry->Next != 0)
      HashEntry->Next->Prev = Node;
    HashEntry->Next = Node;
    Node->Token0 = Token0;
    Node->Token1 = Token1;
  }
  NextDynamicTokenNumber++;
  NextDynamicTokenNumber &= 255;
  Z_DefineAndDisplayDynamicToken(TokenType,TokenByteCount);
  if (BigEndian)
    {
      register byte *Pointer = Token.Characters;
      register int ByteCount = TokenByteCount;
      while (--ByteCount >= 0) OutputByte(*Pointer++);
    }
  else
    {
      register int i;
      for (i=0; i<TokenByteCount; i++)
	OutputByte(Token.Characters[(i&4)+3-(i&3)]);
    }
 Done:
  return OutputPointer-OutputBuffer;
}

hidden procedure InitTextCompressor()
{
  register struct TokenNode *Node = Nodes, **HashEntry = HashTable;
  register int i;
  union TokenWords Token;
  NextDynamicTokenNumber = 0;
  for (i=0; i<256; i++)
    {
      *HashEntry++ = 0;
      Node->Next = 0;
      Node->Prev = 0;
      Node->Token0 = 0;
      Node->Token1 = 0;
      Node++;
    }
  BigEndian = true;
  Token.Words[0] = 0x01020304;
  if (Token.Characters[0] == 4)
    BigEndian = false;
}


hidden int CompressText(WantText,CharacterCount,OutputBuffer)
     byte *WantText, *OutputBuffer;
     int CharacterCount;
{
  register byte *OutputPointer = OutputBuffer;
  register byte *WantPointer = WantText;
  register byte Character;
  register word Token0, Token1;
  register int NibbleCount;
  byte LastCharacter, SavedCharacter, *Pointer;
  int TokenType, Letter;
  SavedCharacter = WantPointer[CharacterCount];
  WantPointer[CharacterCount] = 0x80;
  WantPointer++;
  while (true)
    switch (Character = WantPointer[-1])
      {
	/*
	  Control Characters
	*/
	case 0x00:  case 0x01:	case 0x02:  case 0x03:	case 0x04:
	case 0x05:  case 0x06:	case 0x07:  case 0x08:	case 0x09:
	case 0x0A:  case 0x0B:	case 0x0C:  case 0x0D:	case 0x0E:
	case 0x0F:  case 0x10:	case 0x11:  case 0x12:	case 0x13:
	case 0x14:  case 0x15:	case 0x16:  case 0x17:	case 0x18:
	case 0x19:  case 0x1A:	case 0x1B:  case 0x1C:	case 0x1D:
	case 0x1E:  case 0x1F:	case 0x7F:
	  abort();
	  break;

	/*
	  Space Character
	*/
	case ' ':
	  if (*WantPointer++ != Character)
	    {
	      OutputByte(Character);
	      break;
	    }
	  Pointer = WantPointer;
	  while (*WantPointer++ == Character) ;
	  Z_OverwriteSpaces(WantPointer-Pointer+1);
	  break;
	/*
	  Non-Letter Graphic Characters
	*/
	case '!':  case '"':  case '#':	 case '$':  case '%':  case '&':
	case '\'':  case '(':  case ')':  case '*':  case '+':	case ',':
	case '-':  case '.':  case '/':	 case '0':  case '1':  case '2':
	case '3':  case '4':  case '5':	 case '6':  case '7':  case '8':
	case '9':  case ':':  case ';':	 case '<':  case '=':  case '>':
	case '?':  case '@':  case '[':	 case '\\':  case ']':	case '^':
	case '_':  case '`':  case '{':	 case '|':  case '}':  case '~':
	Graphic:
	  if (*WantPointer++ != Character)
	    {
	      OutputByte(Character);
	      break;
	    }
	  if (*WantPointer++ != Character)
	    {
	      OutputByte(Character);
	      OutputByte(Character);
	      break;
	    }
	  Pointer = WantPointer;
	  while (*WantPointer++ == Character) ;
	  Z_OverwriteCharacters(WantPointer-Pointer+2,Character);
	  break;

	/*
	  Upper Case Letters
	*/
	case 'A':  case 'B':  case 'C':	 case 'D':  case 'E':  case 'F':
	case 'G':  case 'H':  case 'I':	 case 'J':  case 'K':  case 'L':
	case 'M':  case 'N':  case 'O':	 case 'P':  case 'Q':  case 'R':
	case 'S':  case 'T':  case 'U':	 case 'V':  case 'W':  case 'X':
	case 'Y':  case 'Z':
	  if (WantPointer[0] == Character && WantPointer[1] == Character)
	    goto Graphic;
	  LastCharacter = Character;
	  Character = *WantPointer++;
	  if (Character >= 'a' && Character <= 'z') goto Capitalize;
	  if (Character < 'A' || Character > 'Z')
	    {
	      OutputByte(LastCharacter);
	      break;
	    }
	  if (WantPointer[0] == Character && WantPointer[1] == Character)
	    {
	      OutputByte(LastCharacter);
	      goto Graphic;
	    }
	  Token1 = 0;
	  TokenType = 2;
	  NibbleCount = 16-1;
	  if (PrefixedNibble[LastCharacter -= 'A']) --NibbleCount;
	  Token0 = Nibbles[LastCharacter] << Shifts[NibbleCount-8];
	  while (true)
	    {
	      if (--NibbleCount < 0) break;
	      if (PrefixedNibble[Letter = Character-'A'] && --NibbleCount < 0)
		break;
	      if (NibbleCount >= 8)
		Token0 |= Nibbles[Letter] << Shifts[NibbleCount-8];
	      else Token1 |= Nibbles[Letter] << Shifts[NibbleCount];
	      Character = *WantPointer++;
	      if (Character < 'A' || Character > 'Z') break;
	      if (WantPointer[0] == Character && WantPointer[1] == Character)
		{
		  OutputPointer +=
		    LookupToken(Token0,Token1,TokenType,
				8-(NibbleCount>>1),OutputPointer);
		  goto Graphic;
		}
	    }
	  if (Character == ' ')
	    {
	      TokenType++;
	      WantPointer++;
	    }
	  if (NibbleCount < 0) NibbleCount++;
	  OutputPointer += LookupToken(Token0,Token1,TokenType,
				       8-(NibbleCount>>1),OutputPointer);
	  break;

	Capitalize:
	  if (WantPointer[0] == Character && WantPointer[1] == Character)
	    {
	      OutputByte(LastCharacter);
	      goto Graphic;
	    }
	  Token1 = 0;
	  TokenType = 6;
	  NibbleCount = 16-1;
	  if (PrefixedNibble[LastCharacter -= 'A']) --NibbleCount;
	  Token0 = Nibbles[LastCharacter] << Shifts[NibbleCount-8];
	  while (true)
	    {
	      if (--NibbleCount < 0) break;
	      if (PrefixedNibble[Letter = Character-'a'] && --NibbleCount < 0)
		break;
	      if (NibbleCount >= 8)
		Token0 |= Nibbles[Letter] << Shifts[NibbleCount-8];
	      else Token1 |= Nibbles[Letter] << Shifts[NibbleCount];
	      Character = *WantPointer++;
	      if (Character < 'a' || Character > 'z') break;
	      if (WantPointer[0] == Character && WantPointer[1] == Character)
		{
		  OutputPointer +=
		    LookupToken(Token0,Token1,TokenType,
				8-(NibbleCount>>1),OutputPointer);
		  goto Graphic;
		}
	    }
	  if (Character == ' ')
	    {
	      TokenType++;
	      WantPointer++;
	    }
	  if (NibbleCount < 0) NibbleCount++;
	  OutputPointer += LookupToken(Token0,Token1,TokenType,
				       8-(NibbleCount>>1),OutputPointer);
	  break;

	/*
	  Lower Case Letters
	*/
	case 'a':  case 'b':  case 'c':	 case 'd':  case 'e':  case 'f':
	case 'g':  case 'h':  case 'i':	 case 'j':  case 'k':  case 'l':
	case 'm':  case 'n':  case 'o':	 case 'p':  case 'q':  case 'r':
	case 's':  case 't':  case 'u':	 case 'v':  case 'w':  case 'x':
	case 'y':  case 'z':
	  if (WantPointer[0] == Character && WantPointer[1] == Character)
	    goto Graphic;
	  LastCharacter = Character;
	  Character = *WantPointer++;
	  if (Character < 'a' || Character > 'z')
	    {
	      OutputByte(LastCharacter);
	      break;
	    }
	  if (WantPointer[0] == Character && WantPointer[1] == Character)
	    {
	      OutputByte(LastCharacter);
	      goto Graphic;
	    }
	  Token1 = 0;
	  TokenType = 4;
	  NibbleCount = 16-1;
	  if (PrefixedNibble[LastCharacter -= 'a']) --NibbleCount;
	  Token0 = Nibbles[LastCharacter] << Shifts[NibbleCount-8];
	  while (true)
	    {
	      if (--NibbleCount < 0) break;
	      Letter = Character - 'a';
	      if (PrefixedNibble[Letter] && --NibbleCount < 0) break;
	      if (NibbleCount >= 8)
		Token0 |= Nibbles[Letter] << Shifts[NibbleCount-8];
	      else Token1 |= Nibbles[Letter] << Shifts[NibbleCount];
	      Character = *WantPointer++;
	      if (Character < 'a' || Character > 'z') break;
	      if (WantPointer[0] == Character && WantPointer[1] == Character)
		{
		  OutputPointer +=
		    LookupToken(Token0,Token1,TokenType,
				8-(NibbleCount>>1),OutputPointer);
		  goto Graphic;
		}
	    }
	  if (Character == ' ')
	    {
	      TokenType++;
	      WantPointer++;
	    }
	  if (NibbleCount < 0) NibbleCount++;
	  OutputPointer += LookupToken(Token0,Token1,TokenType,
				       8-(NibbleCount>>1),OutputPointer);
	  break;

	/*
	  End-of-String Characters
	*/
	default:
	  goto Done;
      }
 Done:
  WantText[CharacterCount] = SavedCharacter;
  return OutputPointer-OutputBuffer;
}
