# Modified on 23-Jan-91 by Leonard N. Zubkoff:
#   Changed CFLAGS from "-g" to "-O".
#   Build executables with name $file.x.

CFLAGS= -O
# For Xenix.  Needed for movemail
#  LOADLIBES= -lx
# For Mips.  Needed for who knows what.
#  LOADLIBES = -lmld /usr/bsd43/usr/lib/libc.a

EXECUTABLES = test-distrib etags.x ctags.x wakeup.x make-docfile \
   digest-doc.x sorted-doc.x movemail.x cvtmail.x fakemail.x yow.x env.x \
   server.x emacsclient.x

all: ${EXECUTABLES}

clean:
	-rm -f ${EXECUTABLES} core

distclean:
	-rm -f ${EXECUTABLES} *~ \#* DOC* core

# This justs verifies that the non-ASCII characters
# in the file `testfile' have no been clobbered by
# whatever means were used to copy and distribute Emacs.
# If they were clobbered, all the .elc files were clobbered too.
test-distrib: test-distrib.c
	$(CC) -o test-distrib test-distrib.c
	./test-distrib

etags.x: etags.c
	$(CC) -o etags.x ${CFLAGS} -DETAGS etags.c $(LOADLIBES)

ctags.x: etags.c
	$(CC) -o ctags.x ${CFLAGS} -DCTAGS etags.c $(LOADLIBES)

wakeup.x: wakeup.c
	$(CC) -o wakeup.x ${CFLAGS} wakeup.c $(LOADLIBES)

make-docfile: make-docfile.c
	$(CC) -o make-docfile ${CFLAGS} make-docfile.c $(LOADLIBES)

digest-doc.x: digest-doc.c
	$(CC) -o digest-doc.x ${CFLAGS} digest-doc.c $(LOADLIBES)

sorted-doc.x: sorted-doc.c
	$(CC) -o sorted-doc.x ${CFLAGS} sorted-doc.c $(LOADLIBES)

#
movemail.x: movemail.c ../src/config.h
	$(CC) -o movemail.x ${CFLAGS} movemail.c $(LOADLIBES)

cvtmail.x: cvtmail.c
	$(CC) -o cvtmail.x ${CFLAGS} cvtmail.c $(LOADLIBES)

fakemail.x: fakemail.c ../src/config.h
	$(CC) -o fakemail.x ${CFLAGS} fakemail.c $(LOADLIBES)

yow.x: yow.c ../src/paths.h
	$(CC) -o yow.x ${CFLAGS} yow.c $(LOADLIBES)

# this is silly -- just use emacs to edit this file!
# (in any case this program doesn't preserve alphabetical ordering,
#  which is why I'm removing it)
#addyow: addyow.c
#	$(CC) -o addyow ${CFLAGS} addyow.c

env.x: env.c ../src/config.h
	$(CC) -o env.x -DEMACS ${CFLAGS} env.c $(LOADLIBES)

server.x: server.c ../src/config.h
	$(CC) -o server.x ${CFLAGS} server.c $(LOADLIBES)

emacsclient.x: emacsclient.c ../src/config.h
	$(CC) -o emacsclient.x ${CFLAGS} emacsclient.c $(LOADLIBES)

# This one is NOT included in EXECUTABLES.
# See ../src/ymakefile.
emacstool: emacstool.c
	$(CC) -o emacstool ${CFLAGS} emacstool.c -lsuntool -lsunwindow -lpixrect $(LOADLIBES)

nemacstool: emacstool.c
	$(CC) -o nemacstool ${CFLAGS} -DJLE emacstool.c -lsuntool -lmle -lsunwindow -lpixrect $(LOADLIBES)	# For SUN Japanese Language Environment

xvetool: emacstool.c
	$(CC) -o xvetool ${CFLAGS} -DXVIEW         emacstool.c -lxview -lolgx -lX -I$(OPENWINHOME)/include -L$(OPENWINHOME)/lib $(LOADLIBES)

xveterm: emacstool.c
	$(CC) -o xveterm ${CFLAGS} -DXVIEW -DTTERM emacstool.c -lxview -lolgx -lX -I$(OPENWINHOME)/include -L$(OPENWINHOME)/lib $(LOADLIBES)


