;;; Site GNU Emacs Customizations for Lucid
;;;
;;; Author:	Leonard N. Zubkoff
;;; Revision:	 3-Jan-93 21:29:18


;;; Define some variables...

(setq auto-mode-alist
      (append '(("\\.lisp~$" . lisp-mode)
		("\\.txt$" . text-mode)
		("\\.txt~$" . text-mode)
                ("\\.mss~$" . scribe-mode))
	      auto-mode-alist))

(setq completion-ignored-extensions
      (append '("0" "1" "2" "3" "4" "5" "6" "7" "8" "9"
                ".log" "bin" "lap" ".tc" ".toc" "#")
	      completion-ignored-extensions))


;;; By default, don't reply to INFO- or LUCID mailing lists.

(setq rmail-default-dont-reply-to-names "info-\\|lucid\\>")


;;; Load some files...

(load "backquote")
(load "buff-menu")
(load "buffer-merge")
(load "cl-indent")
(load "compare-w")
(load "dabbrev")
(load "dired")
(load "ebuff-menu")
(load "electric")
(load "info")
(load "macros")
(load "mail-utils")
(load "mailalias")
(load "makesum")
(load "man")
(load "picture")
(load "rect")
(load "rmail")
(load "rmailedit")
(load "rmailkwd")
(load "rmailmsc")
(load "rmailout")
(load "rmailsum")
(load "rnews")
(load "rnewspost")
(load "sendmail")
(load "server")
(load "shell")
(load "telnet")
(load "shell-history")
(load "sort")
(load "spell")
(load "tabify")
(load "tags")
(load "tex-mode")
(load "time")
(load "userlock")
(load "view")


;;; Define some hooks...

(setq lisp-indent-hook 'common-lisp-indent-hook)
(put 'loop 'common-lisp-indent-hook 0)
(put 'once-only 'common-lisp-indent-hook 1)
(put 'select 'common-lisp-indent-hook 1)
(put 'def-foreign-struct 'common-lisp-indent-hook
     '((&whole 4 &rest (&whole 2 &rest 1))
       &rest (&whole 2 &rest 1)))
(put 'deflap 'common-lisp-indent-hook
     '(2 2 (&whole 2) &body))
(put 'deflispfun 'common-lisp-indent-hook 3)
(put 'defprimop 'common-lisp-indent-hook 3)
(put 'deftransform 'common-lisp-indent-hook 3)
(put 'do-regions 'common-lisp-indent-hook 0)
(put 'with-interrupts-deferred 'common-lisp-indent-hook 0)
(put 'with-interrupts-allowed 'common-lisp-indent-hook 0)
(put 'with-normal-consing-area 'common-lisp-indent-hook 0)
(put 'with-readonly-non-pointer-area 'common-lisp-indent-hook 0)
(put 'with-readonly-pointer-area 'common-lisp-indent-hook 0)
(put 'with-read-write-area 'common-lisp-indent-hook 0)
(put 'with-static-area 'common-lisp-indent-hook 0)
(put 'with-dynamic-area 'common-lisp-indent-hook 0)
(put 'with-foreign-area 'common-lisp-indent-hook 0)


;;; Define some functions...

(defun edit-history ()
  "Makes an edit-history entry, inserting a header if needed."
  (interactive)
  (set-mark-command nil)
  (beginning-of-buffer)
  (let* ((date (current-time-string))
	 (len (length date)))
    (if (search-forward ";;; End-of-Edit-History" nil t)
	;; found the header - use it
	(progn
	  (beginning-of-line 1)
	  (previous-line 1)
	  (open-line 1)
	  (insert ";;; " (substring date 8 10) "-"
		  (substring date 4 7) "-" (substring date (- len 2) len)
		  " " (user-login-name) ": "))
	;; Header not found - insert it
	(progn
	  (insert-file "/lucid/buro/hdr")
	  (if (buffer-file-name)
	      (let ((fn (file-name-nondirectory (buffer-file-name))))
		(save-excursion (replace-string "<file name>" fn))
		(save-excursion (replace-string "<file-name>" fn))))
	  (if (search-forward "Programmer: " nil t)
	      (insert (user-full-name)))
	  (if (search-forward "Created: ")
	      (progn
		(kill-line nil)
		(insert (substring date 8 10) "-"
			(substring date 4 7) "-"
			(substring date (- len 2) len) " by "
			(user-login-name))
		(if (null (search-backward "<short-description" nil t))
		    (exchange-point-and-mark)))
	      (exchange-point-and-mark))))))

(fset 'hdr 'edit-history)

(defun make-auto-save-file-name ()
  "Return file name to use for auto-saves of current buffer.
Does not consider auto-save-visited-filename; that is checked
before calling this function.  Auto-save file names at Lucid
just end with a #."
  (if buffer-file-name
      (if (equal ?\# (aref buffer-file-name (1- (length buffer-file-name))))
	  buffer-file-name 
	  (concat buffer-file-name "#"))
    (expand-file-name (concat (buffer-name) "#"))))

(defun rmail-reply-to-sender (include-ccs)
  "Reply to the current message.
Normally excludes CC: to all other recipients of the original message;
prefix argument means include them.
While composing the reply, use \\[mail-yank-original] to yank the
original message into it."
  (interactive "P")
  (rmail-reply (not include-ccs)))
