/*
  Modified on 23-Jan-91 by Leonard N. Zubkoff:
    Use GNU Emacs termcap rather than system termcap.  Added support
    for unexec on Apollo.  Added -W0,-ncompress to C_SWITCH_MACHINE.
*/

/* m- file for Apollo machine.
   Copyright (C) 1985, 1986 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* The following three symbols give information on
 the size of various data types.  */

#define SHORTBITS 16		/* Number of bits in a short */

#define INTBITS 32		/* Number of bits in an int */

#define LONGBITS 32		/* Number of bits in a long */

/* 68020/68030/68040 and PRISM have lowest-numbered byte as most significant */

#define BIG_ENDIAN

/* Define how to take a char and sign-extend into an int.
   On machines where char is signed, this is a no-op.  */

#define SIGN_EXTEND_CHAR(c) (c)

#define APOLLO

/* Enable Apollo Display support. */

#define APOLLO_DISPLAY

/* Use type int rather than a union, to represent Lisp_Object */

#define NO_UNION_TYPE

/* Data type of load average, as read out of kmem.  */

#define LOAD_AVE_TYPE long

/* Convert that into an integer that is 100 for a load average of 1.0  */

#define LOAD_AVE_CVT(x) (int) (((double) (x)) * 100.0 / 65536.0)

/* Undefine VIRT_ADDR_VARIES because the virtual addresses of
   pure and impure space as loaded do not vary.  */

#undef VIRT_ADDR_VARIES

/* Define HAVE_ALLOCA because we use the system's version of alloca.  */

#define HAVE_ALLOCA

/* Allow Emacs's larger than 16 megabytes. */

#define VALBITS 26
#define GCTYPEBITS 5

/* Prevent -lg from being used for debugging. */

#define LIBS_DEBUG

/* Must not use the system's termcap with GPR support. */

#undef LIBS_TERMCAP

/* Need not use the system's malloc. */

#undef SYSTEM_MALLOC

/* System Type is Domain/OS. */

#undef SYSTEM_TYPE
#define SYSTEM_TYPE "Domain/OS"

/* Define O_NOCTTY since it is omitted in the BSD4.3 include file. */

#define O_NOCTTY 04000

/* Define the file we use for UNEXEC. */

#define UNEXEC unexapollo.o

/* Define that the executable file format is COFF. */

#define COFF

/* In SR10.2 we use our own version of crt0. */

#define START_FILES crt0.o

/* Don't define environ in crt0.c. */

#define DONT_NEED_ENVIRON

/* Define C_SWITCH_MACHINE to compile for 68020/68030/68040 or PRISM. */

#if _ISP__A88K
#define C_SWITCH_MACHINE -A cpu,10000 -W0,-ncompress
#else
#define C_SWITCH_MACHINE -A cpu,3000 -W0,-ncompress
#endif

/* Define LD_SWITCH_MACHINE to save space by stripping symbols
   and use X11 libraries. */

#define LD_SWITCH_MACHINE -s -L/usr/lib/X11

/* Define machine-specific modifications to ymakefile. */

#define OBJECTS_MACHINE /sys/traits/io_traits.2
#define OTHER_FILES ngt
