/*
  Created on 23-Jan-91 by Leonard N. Zubkoff:
    Site specific common configuration parameters for Lucid.
*/


/* Allow Emacs's larger than 16 megabytes.  */

#ifndef VALBITS
#define VALBITS 26
#define GCTYPEBITS 5
#endif

/* Enable Apollo Display support. */

#ifndef APOLLO_DISPLAY
#define APOLLO_DISPLAY
#endif

/* Define `subprocesses' should be defined if you want to
   have code for asynchronous subprocesses
   (as used in M-x compile and M-x shell).
   These do not work for some USG systems yet;
   for the ones where they work, the s-*.h file defines this flag.  */

#ifndef VMS
#ifndef USG
#define subprocesses
#endif
#endif

/* Define USER_FULL_NAME to return a string
   that is the user's full name.
   It can assume that the variable `pw'
   points to the password file entry for this user.

   At some sites, the pw_gecos field contains
   the user's full name.  If neither this nor any other
   field contains the right thing, use pw_name,
   giving the user's login name, since that is better than nothing.  */

#define USER_FULL_NAME pw->pw_gecos

/* Define AMPERSAND_FULL_NAME if you use the convention
   that & in the full name stands for the login id.  */

/* #define AMPERSAND_FULL_NAME */

/* Increase PURESIZE at LUCID to allow loading of various files.  */

#define PURESIZE 305000

/* Define HIGHPRI as a negative number
   if you want Emacs to run at a higher than normal priority.
   For this to take effect, you must install Emacs with setuid root.
   Emacs will change back to the users's own uid after setting
   its priority.  */

/* #define HIGHPRI */

/* Maintain Environments. */

#define MAINTAIN_ENVIRONMENT

/* Define configuration-specific symbol interning functions. */

#define SYMS_CONFIG syms_of_string_ops()

/* Define configuration-specific modifications to ymakefile. */

#define DOBJECTS_CONFIG stringops.o
#define LISP_CONFIG1 ${lispdir}backquote.elc \
		     ${lispdir}buff-menu.elc \
		     ${lispdir}buffer-merge.elc \
		     ${lispdir}cl-indent.elc \
		     ${lispdir}compare-w.elc \
		     ${lispdir}dabbrev.elc \
		     ${lispdir}dired.elc \
		     ${lispdir}ebuff-menu.elc \
		     ${lispdir}electric.elc \
		     ${lispdir}info.elc \
		     ${lispdir}macros.elc \
		     ${lispdir}mail-utils.elc \
		     ${lispdir}mailalias.elc \
		     ${lispdir}makesum.elc \
		     ${lispdir}man.elc
#define LISP_CONFIG2 ${lispdir}picture.elc \
		     ${lispdir}rect.elc \
		     ${lispdir}rmail.elc \
		     ${lispdir}rmailedit.elc \
		     ${lispdir}rmailkwd.elc \
		     ${lispdir}rmailmsc.elc \
		     ${lispdir}rmailout.elc \
		     ${lispdir}rmailsum.elc \
		     ${lispdir}rnews.elc \
		     ${lispdir}rnewspost.elc \
		     ${lispdir}sendmail.elc \
		     ${lispdir}server.elc \
		     ${lispdir}shell.elc
#define LISP_CONFIG3 ${lispdir}shell-history.elc \
		     ${lispdir}sort.elc \
		     ${lispdir}spell.elc \
		     ${lispdir}tabify.elc \
		     ${lispdir}tags.elc \
		     ${lispdir}telnet.elc \
		     ${lispdir}tex-mode.elc \
		     ${lispdir}time.elc \
		     ${lispdir}userlock.elc \
		     ${lispdir}view.elc
