/*
 * FileName:   test-chroot.c
 * $Source: $
 * $Author: $
 * $Date: $
 * $Locker: $
 * $State: $
 * $Revision: $
 * Description:
 *	Check if the new chroot command works.
 *
 * History:
 *      First created by Willem Jan Withagen ( wjw@eb.ele.tue.nl ),
 *                    on Tue Jun  4 11:47:38 EET 1991
 * $Log: $
 */

static char RCSid[]={"$Header: $"};

/*
 *  Include some standard C header files
 */
#include <stdio.h>
#include <assert.h>
#include <sys/param.h>

static char * root;

int chroot(char * s)
{   /* 
     *	Keep what is defined to be the root for this FTP
     *  session.
     */          
    char actualpath[MAXPATHLEN];

    /*  First we really go there.
     *  This is to circumvent any softlinks which might be in the
     *  the path.
     */
    if (chdir(s))
	return -1;              
    /* Then get the pathname
     */
    getwd(actualpath);
#ifdef TEST
    printf( "current directory: %s\n", actualpath );
#endif
    root = (char *) malloc(strlen(actualpath)+2);
    if (!root)
	return -2;
    strcpy(root,actualpath);
    strcat(root,"/");
    return 0;
}

void main(int argc, char *argv[])
{                         
    if (argc>1) {
	printf( "changing root-dir to %s\n", argv[1] );
	printf( "Result: %d\n", chroot( argv[1] ));
    } else
	printf( "Have to supply at least a dir as argument\n");
}
