/*
 * FileName:   test-getwd.c
 * $Source: $
 * $Author: $
 * $Date: $
 * $Locker: $
 * $State: $
 * $Revision: $
 * Description:
 *	Check to see if a pathname returned with getwd returns
 *	different strings for a local dir or a remote dir.

NAME
     getwd - get current working directory pathname

SYNOPSIS
     char *getwd(pathname)
     char *pathname;

DESCRIPTION
     getwd copies the absolute pathname of the current working directory to
     pathname and returns a pointer to the result.

LIMITATIONS
     Maximum pathname length is MAXPATHLEN characters (1024), as defined in
     <sys/param.h>.

DIAGNOSTICS
     getwd returns 0 and places a message in pathname if an error occurs.
 

 * History:
 *      First created by Willem Jan Withagen ( wjw@eb.ele.tue.nl ),
 *                    on Mon Jun  3 18:12:34 EET 1991
 * $Log: $
 */

static char RCSid[]={"$Header: $"};

/*
 *  Include some standard C header files
 */
#include <stdio.h>
#include <assert.h>
#include <sys/param.h>

void main(void)
{             
	static char name[MAXPATHLEN];

	getwd(name);
	printf("Current directory %s\n", name );
}
