static char *
abspath (rel_filename)
     char *rel_filename;
{
  /* Setup the current working directory as needed.  */
  char *abs_buffer
    = (char *) alloca (strlen (cwd) + strlen (rel_filename) + 1);
  char *endp = abs_buffer;
  char *outp, *inp;
  char *value;

  /* Copy the filename (possibly preceded by the current working
     directory name) into the absolutization buffer.  */

  {
    char *src_p;

    if (rel_filename[0] != '/')
      {
        src_p = cwd;
        while (*endp++ = *src_p++)
          continue;
        *(endp-1) = '/';        		/* overwrite null */
      }
    src_p = rel_filename;
    while (*endp++ = *src_p++)
      continue;
    if (endp[-1] == '/')
      *endp = '\0';

  /* Now make a copy of abs_buffer into abs_buffer, shortening the
     filename (by taking out slashes and dots) as we go.  */

  outp = inp = abs_buffer;
  *outp++ = *inp++;        	/* copy first slash */
  for (;;)
    {
      if (!inp[0])
        break;
      else if (inp[0] == '/' && outp[-1] == '/')
        {
          inp++;
          continue;
        }
      else if (inp[0] == '.' && outp[-1] == '/')
        {
          if (!inp[1])
                  break;
          else if (inp[1] == '/')
            {
                    inp += 2;
                    continue;
            }
          else if ((inp[1] == '.') && (inp[2] == 0 || inp[2] == '/'))
            {
                    inp += (inp[2] == '/') ? 3 : 2;
                    outp -= 2;
                    while (outp >= abs_buffer && *outp != '/')
              	outp--;
                    if (outp < abs_buffer)
                {
                  /* Catch cases like /.. where we try to backup to a
                     point above the absolute root of the logical file
                     system.  */

              	  fprintf (stderr, "%s: invalid file name: %s\n",
			   pname, rel_filename);
              	  exit (1);
              	}
                    *++outp = '\0';
                    continue;
            }
        }
      *outp++ = *inp++;
    }

  /* On exit, make sure that there is a trailing null, and make sure that
     the last character of the returned string is *not* a slash.  */

  *outp = '\0';
  if (outp[-1] == '/')
    *--outp  = '\0';

  /* Make a copy (in the heap) of the stuff left in the absolutization
     buffer and return a pointer to the copy.  */

  value = (char *) oballoc (strlen (abs_buffer) + 1);
  strcpy (value, abs_buffer);
  return value;
}
