/* Output everything about a symbol block (a BLOCK node
   that represents a scope level),
   including recursive output of contained blocks.

   BLOCK is the BLOCK node.
   DEPTH is its depth within containing symbol blocks.
   ARGS is usually zero; but for the outermost block of the
   body of a function, it is a chain of PARM_DECLs for the function parameters.
   We output definitions of all the register parms
   as if they were local variables of that block.

   If -g1 was used, we count blocks just the same, but output nothing
   except for the outermost block.

   Actually, BLOCK may be several blocks chained together.
   We handle them all in sequence.  */

static void
dstout_block (block, depth, args)
     register tree block;
     int depth;
     tree args;
{
  int blocknum;

  while (block)
    {
      /* Ignore blocks never expanded or otherwise marked as real.  */
      if (TREE_USED (block))
	{
	  if (depth > 0 && debug_info_level != DINFO_LEVEL_TERSE)
	    {
	      char buf[20];
	      blocknum = next_block_number++;
#if 0
	      ASM_GENERATE_INTERNAL_LABEL (buf, "LBB", blocknum);

	      if (BLOCK_HANDLER_BLOCK (block))
		{
		  /* A catch block.  Must precede N_LBRAC.  */
		  tree decl = BLOCK_VARS (block);
		  while (decl)
		    {
		      fprintf (asmfile, "%s \"%s:C1\",%d,0,0,", ASM_STABS_OP,
			       IDENTIFIER_POINTER (DECL_NAME (decl)), N_CATCH);
		      assemble_name (asmfile, buf);
		      fprintf (asmfile, "\n");
		      decl = TREE_CHAIN (decl);
		    }
		}
#endif

	      fprintf (asmfile, ".dstblk BLOCK,\"");
	      assemble_name (asmfile, buf);
	      fprintf (asmfile, "\",\"scope\"\n");
	      fprintf (asmfile, ".dstsym SCOPE,\"");
	      assemble_name (asmfile, buf);
	      fprintf (asmfile, "\"\n");
	    }
	  else if (depth > 0)
	    /* Count blocks the same way regardless of debug_info_level.  */
	    next_block_number++;

	  if (debug_info_level != DINFO_LEVEL_TERSE || depth == 0)
	    dstout_syms (BLOCK_VARS (block));
#if 0
	  if (args)
	    dstout_reg_parms (args);
#endif

	  /* Output the subblocks.  */
	  dstout_block (BLOCK_SUBBLOCKS (block), depth + 1, NULL_TREE);

	  /* Refer to the marker for the end of the block.  */
	  if (depth > 0 && debug_info_level != DINFO_LEVEL_TERSE)
	    {
	      char buf[20];
	      ASM_GENERATE_INTERNAL_LABEL (buf, "LBE", blocknum);
	      fprintf (asmfile, ".dstsym END_SCOPE,");
	      assemble_name (asmfile, buf);
	      fprintf (asmfile, "\n");
	    }
	}
      block = BLOCK_CHAIN (block);
    }
}
