/* setjmp.h - ANSI C, POSIX,  NON-LOCAL JUMPS header file. */

#ifndef _SETJMP_INCLUDED
#define	_SETJMP_INCLUDED

#ifndef _SYS_STDSYMS_INCLUDED
#	include <sys/stdsyms.h>
#endif /* _SYS_STDSYMS_INCLUDED */

#define	_JBLEN	13

typedef int	jmp_buf[_JBLEN];

#ifdef _INCLUDE_POSIX_SOURCE

typedef int	sigjmp_buf[_JBLEN];

#endif /* _INCLUDE_POSIX_SOURCE */

#ifdef  __cplusplus
    extern "C" {
#endif

_DECL_FUNC(int,		setjmp,		(jmp_buf __env))
_DECL_FUNC(void,	longjmp,	(jmp_buf __env, int __val))

#ifdef _INCLUDE_APOLLO_SOURCE

_DECL_FUNC(int,		_setjmp,	(jmp_buf __env))
_DECL_FUNC(void,	_longjmp,	(jmp_buf __env, int __val))

#endif /* _INCLUDE_APOLLO_SOURCE */

#ifdef _INCLUDE_POSIX_SOURCE

_DECL_FUNC(int,		sigsetjmp,	(sigjmp_buf __env, int __savemask) )
_DECL_FUNC(void,	siglongjmp,	(const sigjmp_buf __env, int __val) )

#endif /* _INCLUDE_POSIX_SOURCE */

#ifdef  __cplusplus
    }
#endif

#endif /* _SETJMP_INCLUDED */
