/* Apollo m68k environment.  Use with BFD_ASSEMBLER defined.  */

#define TE_APOLLO
#define M68KCOFF
#define TARGET_ARCH bfd_arch_m68k
#define TARGET_FORMAT "apollo-m68k"

/* Section symbols may be used for relocations.  Certain sections other
   than the standard ones always have section symbols.  */
#define obj_sec_sym_ok_for_reloc(SEC) 1
#define SECTION_REQUIRES_SYMBOL(sec) (   ! strcmp (sec->name, ".aptv") \
				      || ! strcmp (sec->name, ".blocks") \
				      || ! strcmp (sec->name, ".lines") \
				      || ! strcmp (sec->name, ".rwdi") \
				      || ! strcmp (sec->name, ".symbols") \
				      || ! strcmp (sec->name, ".unwind"))

/* Weak externals always have COFF symbol type T_INT.  Other externals
   are T_NULL.  The Apollo loader complains about size mismatches if this
   convention is not followed.  */
#define SET_COFF_EXTERN_TYPE(sym) if (S_IS_COMMON (sym)) S_SET_DATA_TYPE (sym, T_INT)

#include "obj-format.h"
