/* This goes away when the math-emulator is fixed */
#define TARGET_CPU_DEFAULT 0400		/* TARGET_NO_FANCY_MATH_387 */

/* This is tested by i386gas.h.  */
#define YES_UNDERSCORES

#include "i386/gstabs.h"

/* Get perform_* macros to build libgcc.a.  */
#include "i386/perform.h"

/* Get generic NetBSD definitions.  */
#include "netbsd.h"

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-Dunix -Di386 -D__NetBSD__ -Asystem(unix) -Asystem(NetBSD) -Acpu(i386) -Amachine(i386)"

#undef SIZE_TYPE
#define SIZE_TYPE "unsigned int"

#undef PTRDIFF_TYPE
#define PTRDIFF_TYPE "int"

#undef WCHAR_TYPE
#define WCHAR_TYPE "short unsigned int"

#define WCHAR_UNSIGNED 1

#undef WCHAR_TYPE_SIZE
#define WCHAR_TYPE_SIZE 16

#define HANDLE_SYSV_PRAGMA

/* There are conflicting reports about whether this system uses
   a different assembler syntax.  wilson@cygnus.com says # is right.  */
#undef COMMENT_BEGIN
#define COMMENT_BEGIN "#"

#undef ASM_APP_ON
#define ASM_APP_ON "#APP\n"

#undef ASM_APP_OFF
#define ASM_APP_OFF "#NO_APP\n"

/* The following macros are stolen from i386v4.h */
/* These have to be defined to get PIC code correct */

/* This is how to output an element of a case-vector that is relative.
   This is only used for PIC code.  See comments by the `casesi' insn in
   i386.md for an explanation of the expression this outputs. */

#undef ASM_OUTPUT_ADDR_DIFF_ELT
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL) \
  fprintf (FILE, "\t.long _GLOBAL_OFFSET_TABLE_+[.-%s%d]\n", LPREFIX, VALUE)

/* Indicate that jump tables go in the text section.  This is
   necessary when compiling PIC code.  */

#define JUMP_TABLES_IN_TEXT_SECTION

/* Don't default to pcc-struct-return, because gcc is the only compiler, and
   we want to retain compatibility with older gcc versions.  */
#define DEFAULT_PCC_STRUCT_RETURN 0

/* Profiling routines, partially copied from i386/osfrose.h.  */

/* Redefine this to use %eax instead of %edx.  */
#undef FUNCTION_PROFILER
#define FUNCTION_PROFILER(FILE, LABELNO)  \
{									\
  if (flag_pic)								\
    {									\
      fprintf (FILE, "\tcall mcount@PLT\n");				\
    }									\
  else									\
    {									\
      fprintf (FILE, "\tcall mcount\n");				\
    }									\
}

/* A C statement or compound statement to output to FILE some
   assembler code to initialize basic-block profiling for the current
   object module.  This code should call the subroutine
   `__bb_init_func' once per object module, passing it as its sole
   argument the address of a block allocated in the object module.

   The name of the block is a local symbol made with this statement:

	ASM_GENERATE_INTERNAL_LABEL (BUFFER, "LPBX", 0);

   Of course, since you are writing the definition of
   `ASM_GENERATE_INTERNAL_LABEL' as well as that of this macro, you
   can take a short cut in the definition of this macro and use the
   name that you know will result.

   The first word of this block is a flag which will be nonzero if the
   object module has already been initialized.  So test this word
   first, and do not call `__bb_init_func' if the flag is nonzero.  */

#undef	FUNCTION_BLOCK_PROFILER
#define FUNCTION_BLOCK_PROFILER(STREAM, LABELNO)			\
do									\
  {									\
    if (!flag_pic)							\
      {									\
	fprintf (STREAM, "\tcmpl $0,%sPBX0\n", LPREFIX);		\
	fprintf (STREAM, "\tjne 0f\n");					\
	fprintf (STREAM, "\tpushl $%sPBX0\n", LPREFIX);			\
	fprintf (STREAM, "\tcall ___bb_init_func\n");			\
	fprintf (STREAM, "0:\n");					\
      }									\
    else								\
      {									\
	fprintf (STREAM, "\tpushl %eax\n");				\
	fprintf (STREAM, "\tmovl %sPBX0@GOT(%ebx),%eax\n");		\
	fprintf (STREAM, "\tcmpl $0,(%eax)\n");				\
	fprintf (STREAM, "\tjne 0f\n");					\
	fprintf (STREAM, "\tpushl %eax\n");				\
	fprintf (STREAM, "\tcall ___bb_init_func@PLT\n");		\
	fprintf (STREAM, "0:\n");					\
	fprintf (STREAM, "\tpopl %eax\n");				\
      }									\
  }									\
while (0)

/* A C statement or compound statement to increment the count
   associated with the basic block number BLOCKNO.  Basic blocks are
   numbered separately from zero within each compilation.  The count
   associated with block number BLOCKNO is at index BLOCKNO in a
   vector of words; the name of this array is a local symbol made
   with this statement:

	ASM_GENERATE_INTERNAL_LABEL (BUFFER, "LPBX", 2);

   Of course, since you are writing the definition of
   `ASM_GENERATE_INTERNAL_LABEL' as well as that of this macro, you
   can take a short cut in the definition of this macro and use the
   name that you know will result.  */

#undef	BLOCK_PROFILER
#define BLOCK_PROFILER(STREAM, BLOCKNO)					\
do									\
  {									\
    if (!flag_pic)							\
      fprintf (STREAM, "\tincl %sPBX2+%d\n", LPREFIX, (BLOCKNO)*4);	\
    else								\
      {									\
	fprintf (STREAM, "\tpushl %eax\n");				\
	fprintf (STREAM, "\tmovl %sPBX2@GOT(%ebx),%eax\n", LPREFIX);	\
	fprintf (STREAM, "\tincl %d(%eax)\n", (BLOCKNO)*4);		\
	fprintf (STREAM, "\tpopl %eax\n");				\
      }									\
  }									\
while (0)

