{[r+,b+,o=80] pasmat options}

PROGRAM gone_program;

{ $Header: //pumpkin_patch/local/source/gone/gone.pas,v 1.5 88/01/12 10:03:52 dennis Exp $ }

    {This program locks the user's node with a message on the screen
    and waits for the user to enter a password.

    Written by:
      Dennis Cottel (dennis@nosc.mil)
      Naval Ocean Systems Center, San Diego, CA  }

 %nolist;
 %include '/sys/ins/base.ins.pas';
 %include '/sys/ins/error.ins.pas';
 %include '/sys/ins/pgm.ins.pas';
 %list;

 %include 'gone.ins.pas';

  CONST
    max_args = 20;

  VAR
    {force RCS string to be embedded in code}
    ident: string_t :=
'$Header: //pumpkin_patch/local/source/gone/gone.pas,v 1.5 88/01/12 10:03:52 dennis Exp $'
    ;

    status: status_$t;

    msg: string_t; {assembled message to send to gone}
    msg_len: pinteger; {chars in the message}


  PROCEDURE check( IN str: string);

   {Prints an error message and terminates the program on bad status.}

    BEGIN
      IF status.all <> status_$ok THEN
        BEGIN
        writeln('** Error in Gone ** :', str);
        error_$print(status);
        pgm_$exit;
        END {not ok} ;
    END {check} ;


  PROCEDURE init(OUT ok: boolean;
                 OUT interactive: boolean);

    {Get arguments from command line.  If none are given, print
    a usage note.}

    VAR
      nargs: pinteger; {number of program arguments counting program name}
      arg_vector: pgm_$argv_ptr; {pointer to the arguments - ignored here}
      ax: pinteger; {argument index}
      arg: string_t; {value of an argument}
      arg_len: integer; {length of an argument}
      cx: integer; {character index}

    BEGIN
      ok := true;
      interactive := false;
      pgm_$get_args(nargs, arg_vector); {how many arguments given?}
      IF nargs = 1 THEN {usage note}
        BEGIN
        ok := false;
        writeln('Usage: gone [-i | message...]');
        writeln('       -i = interactive');
        END {usage note}
      ELSE IF nargs = 2 THEN {one argument, may be -i option}
        BEGIN
        arg_len := pgm_$get_arg(1, arg, status, max_string);
        check('pgm_$get_arg');
        interactive := (arg_len = 2) AND (arg[1] = '-') AND (arg[2] IN ['i',
                       'I']);
        END {one argument given, check for -i option} ;
      IF ok AND NOT interactive THEN {assemble arguments into message}
        BEGIN
        msg_len := 0;
        FOR ax := 1 TO nargs - 1 DO {copy each argument}
          BEGIN
          IF ax <> 1 THEN {stick in a space before next argument}
            BEGIN
            msg_len := msg_len + 1;
            msg[msg_len] := ' ';
            END {add a space} ;
          arg_len := pgm_$get_arg(ax, arg, status, max_string);
          check('pgm_$get_arg');
          FOR cx := 1 TO arg_len DO {copy each character}
            BEGIN
            msg_len := msg_len + 1;
            msg[msg_len] := arg[cx];
            END {copy chars} ;
          END {copy each arg} ;
        END {assemble args} ;
    END; {init}


  PROCEDURE get_msg(VAR done: boolean);

    {Interactively solicits the message from the user.  This routine
    insists on a non-blank message.  The message is placed in the
    global variables 'msg' and 'msg_len'.  An EOF will terminate
    the program.}

    VAR
      c: char;

    BEGIN
      REPEAT
        write('Enter message: ');
        msg_len := 0;
        done := eof; {quit when user enters EOF}
        IF NOT done THEN
          BEGIN
          WHILE NOT eoln DO
            BEGIN
            read(c);
            msg_len := msg_len + 1;
            msg[msg_len] := c;
            END {not eoln} ;
          readln;
          END {not done} ;
      UNTIL (msg_len <> 0) OR done;
    END {get_msg} ;


  PROCEDURE main_program;

    VAR
      ok: boolean; {program arguments were ok}
      interactive: boolean; {solicit messages from user}
      done: boolean; {user entered EOF in interactive mode}

    BEGIN
      init(ok, interactive);
      IF ok THEN
        IF NOT interactive THEN gone(msg, msg_len)
        ELSE {interactive mode}
          REPEAT
            get_msg(done);
            IF NOT done THEN gone(msg, msg_len);
          UNTIL done;
    END {main_program} ;

  BEGIN
    main_program
  END {gone_program} .
