#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pad.h>
#include <apollo/time.h>
#include <apollo/cal.h>
#include <math.h>
#include <signal.h>

static	const	double	pi = 3.1415927 ;

static	short	mz = 16 ;
static	short	mxd[] = {-1, 0, 1, 1, 2, 2, 2, 1, 1, 0,-1,-1,-2,-2,-2,-1};
static	short	myd[] = {-2,-2,-2,-1,-1, 0, 1, 1, 2, 2, 2,-1,-1, 0,-1,-1};

static	short	mxt1[60] ;
static	short	myt1[60] ;
static	short	mxt2[60] ;
static	short	myt2[60] ;
static	short	mxt3[60] ;
static	short	myt3[60] ;

static	double	dmx,
		dmy;
static	double	dhx,
		dhy;
static	int	wx = 20,
		wy = 20,
		dx = 200,
		dy = 200;
static	short	mx,
		my;

static	time_$clock_t	clock ;

void draw(){

	status_$t		st; 
	short		i,ii,j,jj;
	int		z;
	unsigned long	h,m;

	cal_$get_local_time(&clock);
	h = cal_$clock_to_sec(clock);

	gpr_$acquire_display(&st); 
	gpr_$clear(0,&st);
	if ( dx > 120 ) {
		for ( z = 0 ; z < 60 ; z += 1 ) {
			gpr_$move(mxt1[z],myt1[z],&st);
			gpr_$line(mxt1[z],myt1[z],&st);
		}
		for ( z = 0 ; z < 60 ; z += 5 ) {
			gpr_$move(mxt1[z],myt1[z],&st);
			gpr_$line(mxt2[z],myt2[z],&st);
		}
	} else {
		for ( z = 0 ; z < 60 ; z += 5 ) {
			gpr_$move(mxt1[z],myt1[z],&st);
			gpr_$line(mxt1[z],myt1[z],&st);
		}
	}

	z = h % 60 ;
	gpr_$move(mxt1[z],myt1[z],&st);
	gpr_$line(mx,my,&st);

	h += 5 ;
	h /= 60 ;
	h %= 3600 ;
	/* stunden */
	{
		double	phi ;
		phi = (double)h * ( pi / 30.0 / 12.0 );
		i = floor( sin(phi)*dhx) + mx ;
		j = floor(-cos(phi)*dhy) + my ;		
		for ( z = 0 ; z < mz ; z++ ){
			gpr_$move(mxd[z],myd[z],&st);
			gpr_$line(i,j,&st);
		}
	}
	/* minuten */
	h %= 60 ;
	i = mxt1[h];
	j = myt1[h];
	for ( z = 0 ; z < mz ; z++ ){
		gpr_$move(mxd[z],myd[z],&st);
		gpr_$line(i,j,&st);
	}
	gpr_$release_display(&st);

	time_$clock(&clock);
	h = cal_$clock_to_sec(clock);
	h++ ;
	cal_$sec_to_clock( h , &clock );
	time_$wait(time_$absolute,clock,&st);
}

main(argc,argv)int argc; char**argv;{

	status_$t		st; 

	short	i,ii,
		j,jj;

	/*5,26,10,32*/
	if ( argc >= 5 ) {
		dx = atoi(argv[3]) ;
		dy = atoi(argv[4]) ;
	}
	if ( argc >= 3 ) {
		wx = atoi(argv[1]) ;
		wy = atoi(argv[2]) ;
	}

	/* --- open window --- */
	{
		gpr_$disp_char_t	disp_char;
		gpr_$offset_t		bitmap_size;
		gpr_$bitmap_desc_t	bitmap_id;
		short			len;
		gpr_$rgb_plane_t	hi_plane;  
		char*			bitmap_adresse;
		stream_$id_t		stream_id;
		gpr_$pixel_value_t	draw_value = 7 ;
		pad_$window_desc_t	window;
   
		window.top    = wy + 26 ;
		window.left   = wx +  5 ;
		window.width  = dx - 10 ;
		window.height = dy - 35 ;

		pad_$create_window("",0,pad_$transcript,1,window,&stream_id,
			&st);
		pad_$set_border(stream_id,1,false,&st);
		pad_$set_auto_close(stream_id,1,true,&st);
		gpr_$inq_disp_characteristics(gpr_$direct,stream_id,
			sizeof(disp_char),&disp_char,&len,&st);

		hi_plane = disp_char.n_planes - 1;                      
		bitmap_size.x_size = dx ;
		bitmap_size.y_size = dy ;
		gpr_$init(gpr_$direct,stream_id,bitmap_size,
			hi_plane,&bitmap_id,&st);
		gpr_$set_auto_refresh(true,&st);
		gpr_$set_obscured_opt(gpr_$pop_if_obs,&st);

#define window_define_color(nr,r,g,b)active_lut[nr]=(r<<16)+(g<<8)+b

		if ( argc >= 6 ) {
			draw_value = atoi(argv[5]) ;
			gpr_$set_draw_value(draw_value,&st);
			gpr_$set_fill_value(draw_value,&st);
		} else if (hi_plane == 7){
			gpr_$set_draw_value(7,&st);
			gpr_$set_fill_value(7,&st);
		}else{
			gpr_$set_draw_value(7,&st);
			gpr_$set_fill_value(7,&st);
		}
	}
	gpr_$release_display(&st);

	mx = dx / 2 ;
	my = dy / 2 ;
	for ( i = 0 ; i < mz ; i ++ ) mxd[i] += mx ;
	for ( i = 0 ; i < mz ; i ++ ) myd[i] += my ;

	dmx = dx * 0.4 ;
	dmy = dy * 0.4 ;
	dhx = dx * 0.3 ;
	dhy = dy * 0.3 ;

	for ( i = 0 ; i < 60 ; i ++ ) {
		double phi, phi_sin, phi_cos ;
		phi = (double)i / 30.0 * pi ;
		phi_sin = sin(phi) ;
		phi_cos = cos(phi) ;
		mxt1[i] = floor( phi_sin*(double)dx * 0.40) + mx ;
		myt1[i] = floor(-phi_cos*(double)dy * 0.40) + my ;
		mxt2[i] = floor( phi_sin*(double)dx * 0.38) + mx ;
		myt2[i] = floor(-phi_cos*(double)dy * 0.38) + my ;
		mxt3[i] = floor( phi_sin*(double)dx * 0.30) + mx ;
		myt3[i] = floor(-phi_cos*(double)dy * 0.30) + my ;
	}
	for( ;; ) draw() ;
}
