/* pbm2bdf.c - read portable bitmaps and produce a bdf icon font - one icon per character
**
** Copyright (C) 1989 by Tim Lambert (lambert@spectrum.eecs.unsw.oz)
**
** based on original program
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    char name[100], *cp;
    int arg;

    printf("STARTFONT 2.1\n");
    printf("FONT fred\n");
    printf("SIZE 119 72 72\n");
    printf("FONTBOUNDINGBOX 90 120 -29 -59\n");
    printf("STARTPROPERTIES 7\n");
    printf("scaling_factor \"1.000000\"\n");
    printf("max_char_index 255\n");
    printf("default_char 32\n");
    printf("underline_width 1\n");
    printf("overstrike_width 1\n");
    printf("h_spacing 0\n");
    printf("v_spacing 0\n");
    printf("ENDPROPERTIES\n");
    printf("CHARS %d\n",argc-1);
    for( arg = 1; arg < argc; arg++ )
	{
        ifd = fopen( argv[arg], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[arg] );
	    exit( 1 );
	    }
	strcpy( name, argv[arg] );

#ifdef	OS_SYSV
	if ( ( cp = strchr( name, '.' ) ) != 0 )
#else	OS_SYSV
	if ( ( cp = index( name, '.' ) ) != 0 )
#endif	OS_SYSV
	    *cp = '\0';
        doachar(arg,ifd,name);
	}
     if (argc==1)
	{
	ifd = stdin;
	strcpy( name, "noname" );
        doachar(arg,ifd,name);
	}
    printf("ENDFONT\n");
    }

doachar(arg,ifd,name)
    FILE *ifd;
    char name[100];
    int arg;
    {
    bit **bits;
    int rows, cols, padright, row, col;
    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Compute padding to round cols up to the nearest multiple of 8. */
    padright = ( ( cols + 7 ) / 8 ) * 8 - cols;

    printf( "STARTCHAR \"%s\"\n", name );
    printf( "ENCODING %d\n",arg);
    printf( "SWIDTH 0 0\n");
    printf( "DWIDTH %d 0\n",rows);
    printf( "BBX %d %d 0 0\n", cols, rows );
    printf( "BITMAP\n" );

    putinit( );
    for ( row = 0; row < rows; row++ )
	{
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
	printf("\n");
        }
    putrest( );
    }


int item, bitsperitem, bitshift, itemsperline, firstitem;

putinit( )
    {
    itemsperline = 0;
    bitsperitem = 0;
    item = 0;
    bitshift = 3;
    firstitem = 1;
    }

putbit( b )
bit b;
    {
    bitsperitem++;
    if ( b )
	item += 1 << bitshift;
    bitshift--;
    if ( bitsperitem == 4 )
	putitem( );
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    printf( "ENDCHAR\n" );
    }

putitem( )
    {
    itemsperline++;
    printf( "%x", item );
    bitsperitem = 0;
    item = 0;
    bitshift = 3;
    }
