/*********************************************
 *             GIFtoPS Converter             *
 *                                           *
 *      May 16, 1988  by Scott Hemphill      *
 *                                           *
 * I wrote this program, and hereby place it *
 * in the public domain, i.e. there are no   *
 * copying restrictions of any kind.         *
 *					     *
 * This hack just prints out GIF parameters  *
 * for the first image in the file (MPK)     *
 *********************************************/

#include <stdio.h>
char *malloc();
int strncmp();

#define min(x,y) ((x) < (y) ? (x) : (y))
#define FALSE 0
#define TRUE 1

typedef int bool;
typedef struct codestruct {
            struct codestruct *prefix;
            unsigned char first,suffix;
        } codetype;

FILE *infile;
unsigned int screenwidth;           /* The dimensions of the screen */
unsigned int screenheight;          /*   (not those of the image)   */
bool global;                        /* Is there a global color map? */
int globalbits;                     /* Number of bits of global colors */
unsigned char globalmap[256][3];    /* RGB values for global color map */
char colortable[256][3];            /* Hex intensity strings for an image */
unsigned char *raster;              /* Decoded image data */
codetype *codetable;                /* LZW compression code data */
int datasize,codesize,codemask;     /* Decoder working variables */
int clear,eoi;                      /* Special code values */

void usage()
{
        fprintf(stderr,
		"usage: gifinfo [file]\n");
        exit(-1);
}

void fatal(s)
char *s;
{
	fflush(stdout);
        fprintf(stderr,"gifinfo: %s\n",s);
        exit(-1);
}

void checksignature()
{
        char buf[6];

        fread(buf,1,6,infile);
        if (strncmp(buf,"GIF",3)) fatal("file is not a GIF file");
        if (strncmp(&buf[3],"87a",3)) fatal("unknown GIF version number");
}

/* Get information which is global to all the images stored in the file */

void readscreen()
{
        unsigned char buf[7];

        fread(buf,1,7,infile);
        screenwidth = buf[0] + (buf[1] << 8);
        screenheight = buf[2] + (buf[3] << 8);
        global = buf[4] & 0x80;
        if (global) {
            globalbits = (buf[4] & 0x07) + 1;
            fread(globalmap,3,1<<globalbits,infile);
        }
}

/*
 * read image parameters and write them to standard output
 */

void readimage()
{
        unsigned char buf[9];
        unsigned left,top,width,height;
        bool local,interleaved;
        char localmap[256][3];
        int localbits;

        fread(buf,1,9,infile);
        left = buf[0] + (buf[1] << 8);
        top = buf[2] + (buf[3] << 8);
        width = buf[4] + (buf[5] << 8);
        height = buf[6] + (buf[7] << 8);
        local = buf[8] & 0x80;
        interleaved = buf[8] & 0x40;
        if (local)
            localbits = (buf[8] & 0x7) + 1;
	else if (! global)
            fatal("no colormap present for image");

	printf("%d x %d x %d", width, height, local ? localbits : globalbits);
	if (top || left)
		printf("(top, left %d,%d) ", top, left);
	if ((width != screenwidth) || (height != screenheight)) {
		printf(" (screen %d x %d x %d)",
		       screenwidth, screenheight, globalbits);
	}
        putchar('\n');
	exit(1);
}

/* Read a GIF extension block (and do nothing with it). */

void readextension()
{
        unsigned char code,count;
        char buf[255];

        code = getc(infile);
        while (count = getc(infile)) fread(buf,1,count,infile);
}

extern char    *optarg;
extern int      optind;

main(argc,argv)
int argc;
char *argv[];
{
        int quit = FALSE;
	int opt;
        char ch;

	while ((opt = getopt(argc, argv, "")) != EOF) {
		switch (opt) {
		default:
			usage();
			break;
		}
	}

	if (argv[optind] == NULL)
		infile = stdin;
	else if (argv[optind + 1] != NULL)
		usage();
	else {
		infile = fopen(argv[optind],"r");
		if (infile == NULL) {
			perror("gifinfo");
			exit(-1);
		}
	}

        checksignature();
        readscreen();
	printf("%s: ", infile == stdin ? "(stdin)" : argv[optind]);
        do {
            ch = getc(infile);
            switch (ch) {
                case '\0':  break;  /* this kludge for non-standard files */
                case ',':   readimage();
                            break;
                case ';':   quit = TRUE;
                            break;
                case '!':   readextension();
                            break;
                default:    fatal("illegal GIF block type");
                            break;
            }
        } while (!quit);
}
