/* Help                                                    Pat Lynch 01-May-1991
 * 
 * help is a program for displaying, in a window or in the transcript pad, files 
 * which provide help for "local", Mentor "idea", and Apollo "system" 
 * commands. Apollo's Unix manuals are not covered by this command.
 *
 *
 * History -
 *
 *	$Log:$
 *
 */


/*
 *  Include the necessary system files...
 */

#include <stdio.h>
#include <apollo/base.h>
#include <apollo/pad.h>

/*
 * Constant definitions...
 */

#define	SizesMax		6
#define	DirsMax			32
#define	DM_CMD_CV		"(%d,%d)dr;(%d,%d)cv %s\0"
#define CAT_CMD			"/bin/cat %s | /usr/ucb/more\0"
#define	HELPSIZE		"HELPSIZE"
#define	HELPPATH		"HELPPATH"
#define	DEF_TOPIC		"/intro"
#define	DEF_HELPSIZE	"0:0,700:600,60:80"
#define	DEF_HELPDIRS	"/local/help:/idea/sys/help:/sys/help"



/*
 * Global variables...
 */

int		ViewedFiles = 0;
char	*HlpSz[SizesMax];
int		WinSz[SizesMax];
char	*HlpDirs[DirsMax];



/* ========================================================================== *
 *                                  Str2Int                                   *
 * ========================================================================== */
int Str2Int( str )
char *str;
{
	int i;
	int sum = 0;
	
	for (i=0; i<strlen(str); i++) sum = 10*sum + ((int)str[i] - (int)'0');
	return(sum);
} 

/* ========================================================================== *
 *                                   Tile                                     *
 * ========================================================================== */
void Tile( NewSzInt )
int NewSzInt[SizesMax];
{
	int ulx,uly,lrx,lry, off_x,off_y;

	ulx = Str2Int(HlpSz[0]);	
	uly = Str2Int(HlpSz[1]);	
	lrx = Str2Int(HlpSz[2]);	
	lry = Str2Int(HlpSz[3]);
	off_x =	Str2Int(HlpSz[4]);
	off_y =	Str2Int(HlpSz[5]);

	NewSzInt[0] = ulx + ViewedFiles * off_x;
	NewSzInt[1] = uly + ViewedFiles * off_y;
	NewSzInt[2] = lrx + ViewedFiles * off_x;
	NewSzInt[3] = lry + ViewedFiles * off_y;
}
	


/* ========================================================================== *
 *                                   Exist                                    *
 * ========================================================================== */
int Exist( fname )
char *fname;
{
	FILE *Fid;
	if ( (Fid = fopen(fname,"r")) == NULL)
		return(0);
	else
	{
		fclose(Fid);
		return(1);
	}
}


/* ========================================================================== *
 *                                 ExistVar                                   *
 * ========================================================================== */
int ExistVar( env_v, varname )
char *env_v[], *varname;
{
/*
 *   Return a TRUE (1) if the varname is found in the provided environment 
 * vector, or FALSE (0) if it is not...
 */
	int i = -1;
	while (env_v[++i] != NULL)
	{
		if (strncmp(env_v[i],varname,strlen(varname)) == 0)
			return(1);
	}
	return(0);
}

/* ========================================================================== *
 *                                  BrkStr                                    *
 * ========================================================================== */
void BrkStr( str, arr, arrmax )
char *str, *arr[];
{
	int i = 0;

	arr[i++] = str;
	while (*str != '\0')
	{
		if (*str == ' ' || *str == ':' || *str == ',' || *str == '\t')
		{
			*str = '\0';
			if (i < arrmax) 
				arr[i++] = ++str;
			else
				return;
		}
		str++;
	}
	arr[i] = NULL;
}


/* ========================================================================== *
 *                                GetEnvVal                                   *
 * ========================================================================== */
char *GetEnvVal( env_v, var )
char *env_v[], *var;
{
/*
 *   Return a pointer to the value of the specified environmental variable
 * from the provided environment vector...
 */
	int i = -1;
	char *c;

/* 
 * Compare each ENVIRONMENTAL Var=Val pair, looking for "var"...
 */

	while (env_v[++i] != NULL)
	{
    /*
     * Found the variable, return a pointer to that portion of the string
     * beyond the '=' character...
     */
		if (strncmp(env_v[i],var,strlen(var)) == 0)
		{
			c = env_v[i];
			while (*c != '=') c++;
			return(++c);
		}
	}
	return((char *)NULL);
}


/* ========================================================================== *
 *                                 ViewFile                                   *
 * ========================================================================== */

int ViewFile( fname )
char *fname;
{
/*   Given a file's pathname (expected to be absolute), see if the standard
 * output is a locally supported DM pad and if it is open a window to view
 * the file and return a TRUE (1) value. If the standard output is not a 
 * locally supported DM pad, return a FALSE (0) value...
 */

	status_$t			*ErrStat;
	char				*HlpSz[6], Command[1024];
	
	
/*
 * Verify that the stream (stdout) is indeed a local pad...
 */

	pad_$force_prompt(ios_$stdout,ErrStat);
	if (ErrStat->all != status_$ok) return(0);
	

/*
 * Execute the DM command to view the file, using the coordinates of the 
 * HELPSIZE environmental variable...
 */
	sprintf(Command,DM_CMD_CV,WinSz[0],WinSz[1],WinSz[2],WinSz[3],fname);
	pad_$dm_cmd(ios_$stdout,Command,strlen(Command),ErrStat);
	if (ErrStat->all != status_$ok) 
		return(0);
	else
	{
		return(1);
	}
}

/* ========================================================================== *
 *                                  CatFile                                   *
 * ========================================================================== */

int CatFile( fname )
char *fname;
{
/*   Given a file's pathname (expected to be absolute), cat the file to
 * standard output...
 */

	char	Command[1024];

	sprintf(Command,CAT_CMD,fname);
	return(system(Command));
}

/* ========================================================================== *
 *                                   Usage                                    *
 * ========================================================================== */
void Usage()
{
	printf("Usage: help [-a] [topic [sub-topic [sub-topic [...]]]]\n");
}


/* ========================================================================== *
 *                                    main                                    *
 * ========================================================================== */
main(argc,argv,envp)
int argc;
char *argv[], *envp[];
{

	char	FilePath[1024], Topic[1024], Orig_Topic[1024], *opt;
	int		stat, i;
	int		HelpFound = 0;
	int		ShowAll = 0;	
   
/*
 * Get the values for window placement and help directories...
 */

	if (ExistVar(envp,HELPSIZE))
		BrkStr(GetEnvVal(envp,HELPSIZE),HlpSz,SizesMax);
	else
		BrkStr(DEF_HELPSIZE,HlpSz,SizesMax);
	Tile(WinSz);

	if (ExistVar(envp,HELPPATH))
		BrkStr(GetEnvVal(envp,HELPPATH),HlpDirs,DirsMax);
	else
		BrkStr(DEF_HELPDIRS,HlpDirs,DirsMax);

/*
 * Get the topic for which help is sought...
 */

	if (argc < 2)
	{
		strcpy(Topic,DEF_TOPIC);
	}
	else
	{
		i = 1;
		Topic[0] = '\0';
		Orig_Topic[0] = '\0';
		while ((opt = argv[i]) != NULL) {
			if (*opt == '-')
				switch (*(opt + 1)) {
					case 'a':
								ShowAll = 1;
								i++;
								break;
					default:
								Usage();
				}
			else
			{
				sprintf(Topic,"%s/%s",Topic,argv[i]);
				if (Orig_Topic[0] != '\0') strcat(Orig_Topic," ");
				strcat(Orig_Topic,argv[i++]);
			}
		}
	}	 

/*
 * Traverse the list of help directories, looking for a file that
 * matches the topic...
 */

	i = 0;
	while (HlpDirs[i] != NULL)
	{
		sprintf(FilePath,"%s%s.hlp\0",HlpDirs[i++],Topic);
		if (Exist(FilePath))
		{
			if (!ViewFile(FilePath))
				if ( (stat = CatFile(FilePath)) != 0)
				{
					fprintf(stderr,"help: cannot open help file ");
					fprintf(stderr,"\"%s\". status(0x%x)\n",FilePath,stat);
				}
				else {
					HelpFound = 1;
				}
			else {
				HelpFound = 1;
				ViewedFiles++;
				Tile(WinSz);
			}
			if (!ShowAll) break;
		}
	}

	if (!HelpFound) 
		fprintf(stderr,"help: No help was found for \"%s\"\n",Orig_Topic);
}
		
